import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加资料信息
    addMaterial(data, cb) {
        req.post(portal + `/exam/materialType/info/`, data).then(res => {
            cb(res.data)
        })
    },
    // 资料信息列表
    getMaterial(data, cb) {
        req.post(portal + `/exam/materialType/info/query`, data).then(res => {
            cb(res.data)
        })
    },
    // 获取资料分类下拉树
    getMaterTree(data, cb) {
        req.post(portal + `/exam/materialType/type/getTree`, data).then(res => {
            cb(res.data)
        })
    },
    // 修改资料信息
    editMaterial(data, cb) {
        req.put(portal + `/exam/materialType/info/`, data).then(res => {
            cb(res.data)
        })
    },
    // id查询资料分类
    detailId(id, cb) {
        req.get(portal + `/exam/materialType/info/` + id).then(rep => {
            cb(rep.data)
        })
    },
    // 删除单个
    deleteOneEqeSys(ids, cb) {
        return new Promise((resolve, reject) => {
            req.remove(portal + '/exam/materialType/type/' + ids).then(res => {
                resolve(res);
            }, error => {
                reject(error);
            })
        })
    },
    // 删除附件
    removeFile(id, cb) {
        req.remove(portal + `/exam/materialType/info/` + id).then(rep => {
            cb(rep.data)
        })
    },
    //保存排序
    saveSort(data, cb) {
        req.post(portal + `/exam/materialType/info/updateSequence `, data).then(res => {
            cb(res.data)
        })
    },
}