import req from '@/request.js'
const portal = window.context.portal
export default {
	//添加试卷
	addPaper(data, cb) {
		req.post(portal + `/exam/paper/base/`, data).then(res => {
			cb(res.data)
		})
	},
	// 试卷查询
	getPaper(data, cb) {
	    req.post(portal + `/exam/paper/base/query`, data).then(res => {
	        cb(res.data)
	    })
	},
	// 修改试卷
	editPaper(data, cb) {
	    req.put(portal + `/exam/paper/base/`, data).then(res => {
	        cb(res.data)
	    })
	},
	// id查询试卷
	detailIdPaper(id, cb) {
	    req.get(portal + `/exam/paper/base/` + id).then(rep => {
	        cb(rep.data)
	    })
	},
	// 批量删除试卷
	deletePaper(ids, cb) {
	    req.remove(portal + `/exam/paper/base/?ids=` + ids).then(rep => {
	        cb(rep.data)
	    })
	},
	// 获取课目分类下拉树
	getSubTree(data, cb) {
	    req.post(portal + `/exam/subject/info/getTree`, data).then(res => {
	        cb(res.data)
	    })
	},
	//题目列表
	getTopic(data, cb) {
	    req.post(portal + `/exam/questions/info/query`, data).then(res => {
	        cb(res.data)
	    })
	},
	//根据id查询题目选项
	detailIdTopic(id, cb) {
	    req.get(portal + `/exam/questions/info/` + id).then(rep => {
	        cb(rep.data)
	    })
	},
	//预览试卷
	previewPaper(id, cb) {
	    req.get(portal + `/exam/paper/base/viewPaper/` + id).then(rep => {
	        cb(rep.data)
	    })
	},
	//获取岗位
	getOrgPostPage(data, cb) {
	    req.post(portal + `/api/org/v1/orgs/getPositionTree`, data).then(res => {
	        cb(res.data)
	    })
	},
	// 根据选中科目id获取科目下岗位关联人员
	getSubjectUserList(data,cb) {
	    req.post(portal + `/exam/subject/info/getSubjectUserList`, data).then(res => {
	        cb(res.data)
	    })
	},
	//获取人员s
	getOrgUserPage(data,cb){
		req.post(portal + `/api/org/v1/orgUsers/getOrgUserPage`, data).then(res => {
		    cb(res.data)
		})
	},
	//根据课目id查询课目信息
	findBySubjectId(id, cb) {
	    req.get(portal + `/exam/questions/info/findBySubjectId/` + id).then(rep => {
	        cb(rep.data)
	    })
	},
	//获取场地
	pagingQuery(data, cb) {
	  req.post(portal + `/exam/room/info/query`, data).then(res => {
	    cb(res.data)
	  })
	},
	//发布考试
	startPaper(id,cb){
		req.get(portal + `/exam/paper/base/startPaper/` + id).then(rep => {
		    cb(rep.data)
		})
	},
	//添加考生
	addUser(data, cb) {
	  req.post(portal + `/exam/paper/base/addUser`, data).then(res => {
	    cb(res.data)
	  })
	},
	//我的试卷封面
	getTaskInfo(id,cb){
		req.get(portal + `/exam/user/record/getTaskInfo/` + id).then(rep => {
		    cb(rep.data)
		})
	},
	//开始考试
	startExam(data, cb) {
	  req.post(portal + `/exam/user/record/startExam`, data).then(res => {
	    cb(res.data)
	  })
	},
	//提交试卷
	submitAnswer(data, cb) {
	  req.post(portal + `/exam/user/record/submitAnswer`, data).then(res => {
	    cb(res.data)
	  })
	},
	//导入
	importExcel(data, cb) {
	    req.post(portal + `/exam/paper/base/importExcel`, data).then(res => {
	        cb(res.data)
	    })
	},
	//导出
	export(data, cb){
		req.post(portal + `/exam/paper/base/export`, data, 'blob').then(res => {
		    cb(res.data)
		})
	},
	//增加页面切换次数
	switchCount(id,cb){
		req.get(portal + `/exam/user/record/switchCount/` + id).then(rep => {
		    cb(rep.data)
		})
	},
	//获取今年该课目是否已经设置过最终成绩
	getEndStatus(id,cb){
		req.get(portal + `/exam/paper/base/getEndStatus/` + id).then(rep => {
		    cb(rep.data)
		})
	},
}
