/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.usercalc.matrix.content;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.XmlUtil;
import com.artfess.bpm.api.plugin.core.context.AbstractUserCalcPluginContext;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.runtime.RunTimePlugin;
import com.artfess.bpm.plugin.usercalc.matrix.def.MatrixPluginDef;
import com.artfess.bpm.plugin.usercalc.matrix.runtime.MatrixPlugin;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class MatrixPluginContext
extends AbstractUserCalcPluginContext {
    private static final long serialVersionUID = -5261531157333798291L;

    @Override
    public String getDescription() {
        MatrixPluginDef def = (MatrixPluginDef)this.getBpmPluginDef();
        if (def == null) {
            return "";
        }
        return def.getDescription();
    }

    @Override
    public String getTitle() {
        return "\u89d2\u8272\u77e9\u9635";
    }

    @Override
    public Class<? extends RunTimePlugin> getPluginClass() {
        return MatrixPlugin.class;
    }

    @Override
    public String getPluginXml() {
        BpmPluginDef bpmPluginDef = this.getBpmPluginDef();
        MatrixPluginDef def = (MatrixPluginDef)bpmPluginDef;
        if (def == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<matrix xmlns=\"http://www.jee-soft.cn/bpm/plugins/userCalc/matrix\" ");
        sb.append("  logicCal=\"" + def.getLogicCal().getKey() + "\" extract=\"" + def.getExtract().getKey() + "\" code=\"" + def.getCode() + "\" description=\"" + def.getDescription() + "\" roleCode=\"" + def.getRoleCode() + "\" roleName=\"" + def.getRoleName() + "\" name=\"" + def.getName() + "\">");
        sb.append("<params>");
        sb.append("<![CDATA[");
        try {
            sb.append(BeanUtils.isNotEmpty((Object)def.getParams()) ? JsonUtil.toJson((Object)def.getParams()) : "");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        sb.append("]]>");
        sb.append("</params>");
        sb.append("</matrix>");
        return sb.toString();
    }

    @Override
    protected BpmPluginDef parseElement(Element element) {
        MatrixPluginDef def = new MatrixPluginDef();
        String code = element.getAttribute("code");
        String name = element.getAttribute("name");
        String description = element.getAttribute("description");
        String roleCode = element.getAttribute("roleCode");
        String roleName = element.getAttribute("roleName");
        def.setCode(code);
        def.setName(name);
        def.setDescription(description);
        def.setRoleCode(roleCode);
        def.setRoleName(roleName);
        Element paramsEl = XmlUtil.getChildNodeByName((Element)element, (String)"params");
        if (paramsEl != null) {
            try {
                def.setParams(JsonUtil.toJsonNode((String)paramsEl.getTextContent()));
            }
            catch (IOException | DOMException e) {
                e.printStackTrace();
            }
        }
        return def;
    }

    @Override
    protected BpmPluginDef parseJson(ObjectNode pluginJson) throws Exception {
        MatrixPluginDef def = new MatrixPluginDef();
        String code = JsonUtil.getString((JsonNode)pluginJson, (String)"code");
        String name = JsonUtil.getString((JsonNode)pluginJson, (String)"name");
        String description = JsonUtil.getString((JsonNode)pluginJson, (String)"description");
        String roleCode = JsonUtil.getString((JsonNode)pluginJson, (String)"roleCode");
        String roleName = JsonUtil.getString((JsonNode)pluginJson, (String)"roleName");
        def.setCode(code);
        def.setName(name);
        def.setDescription(description);
        def.setRoleCode(roleCode);
        def.setRoleName(roleName);
        if (JsonUtil.isContainsKey((JsonNode)pluginJson, (String)"params")) {
            def.setParams(pluginJson.get("params"));
        }
        return def;
    }
}

