/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.task.BpmTaskOpinion;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.BpmOpinionService;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.util.BoDataUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.workflow.runtime.manager.MeetingRoomAppointmentManager;
import com.artfess.workflow.runtime.model.MeetingRoomAppointment;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal/meetingRoomAppointment/v1"})
@Api(tags={"\u4f1a\u8bae\u5ba4\u9884\u7ea6"})
@ApiGroup(group={"group_bpm"})
public class MeetingRoomAppointmentController
extends BaseController<MeetingRoomAppointmentManager, MeetingRoomAppointment> {
    @Resource
    MeetingRoomAppointmentManager meetingRoomAppointmentManager;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmOpinionService bpmOpinionService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u4f1a\u8bae\u5ba4\u9884\u7ea6\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u4f1a\u8bae\u5ba4\u9884\u7ea6\u5217\u8868")
    public PageList<ObjectNode> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.meetingRoomAppointmentManager.getAppointList(queryFilter);
    }

    @GetMapping(value={"/get/{id}"})
    @ApiOperation(value="\u4f1a\u8bae\u5ba4\u9884\u7ea6\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u4f1a\u8bae\u5ba4\u9884\u7ea6\u6570\u636e\u8be6\u60c5")
    public MeetingRoomAppointment get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return (MeetingRoomAppointment)this.meetingRoomAppointmentManager.get((Serializable)((Object)id));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u4f1a\u8bae\u5ba4\u9884\u7ea6\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u4f1a\u8bae\u5ba4\u9884\u7ea6\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="meetingRoomAppointment", value="\u4f1a\u8bae\u5ba4\u9884\u7ea6\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody MeetingRoomAppointment meetingRoomAppointment) throws Exception {
        String msg = "\u6dfb\u52a0\u4f1a\u8bae\u5ba4\u9884\u7ea6\u6210\u529f";
        if (StringUtil.isEmpty((String)meetingRoomAppointment.getId())) {
            this.meetingRoomAppointmentManager.create((Model)meetingRoomAppointment);
        } else {
            this.meetingRoomAppointmentManager.update((Model)meetingRoomAppointment);
            msg = "\u66f4\u65b0\u4f1a\u8bae\u5ba4\u9884\u7ea6\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"remove/{id}"})
    @ApiOperation(value="\u5220\u9664\u4f1a\u8bae\u5ba4\u9884\u7ea6\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u4f1a\u8bae\u5ba4\u9884\u7ea6\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e1a\u52a1\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        this.meetingRoomAppointmentManager.remove((Serializable)((Object)id));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u4f1a\u8bae\u5ba4\u9884\u7ea6\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u4f1a\u8bae\u5ba4\u9884\u7ea6\u8bb0\u5f55")
    public CommonResult<String> removes(@ApiParam(name="ids", value="\u4e1a\u52a1\u4e3b\u952e\u6570\u7ec4,\u591a\u4e2a\u4e1a\u52a1\u4e3b\u952e\u4e4b\u95f4\u7528\u9017\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        this.meetingRoomAppointmentManager.removeByIds(new String[]{ids});
        return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/pendingJson"})
    @ApiOperation(value="\u5f85\u53c2\u52a0\u4f1a\u8bae", httpMethod="POST", notes="\u5f85\u53c2\u52a0\u4f1a\u8bae")
    public PageList<ObjectNode> pendingJson(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        throw new BaseException("\u672a\u5b9e\u73b0");
    }

    @PostMapping(value={"/myRequestJson"})
    @ApiOperation(value="\u6211\u7684\u53d1\u8d77\u7684\u4f1a\u8bae", httpMethod="POST", notes="\u6211\u7684\u53d1\u8d77\u7684\u4f1a\u8bae")
    public PageList<ObjectNode> myRequestJson(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        queryFilter.addFilter("create_by_", (Object)userId, QueryOP.EQUAL);
        queryFilter.addFilter("PROC_DEF_KEY_", (Object)"hylc", QueryOP.EQUAL);
        queryFilter.addFilter("STATUS_", (Object)"draft", QueryOP.NOT_EQUAL);
        PageList query = this.bpmProcessInstanceManager.query(queryFilter);
        PageList pList = new PageList();
        ArrayList<ObjectNode> insList = new ArrayList<ObjectNode>();
        for (int i = 0; i < query.getRows().size(); ++i) {
            DefaultBpmProcessInstance processInstance = (DefaultBpmProcessInstance)query.getRows().get(i);
            List bpmTaskOpinions = this.bpmOpinionService.getTaskOpinions(processInstance.getId());
            BpmTaskOpinion bto = (BpmTaskOpinion)bpmTaskOpinions.get(bpmTaskOpinions.size() - 1);
            List boDatas = this.boDataService.getDataByInst((BpmProcessInstance)processInstance);
            ObjectNode data = (ObjectNode)BoDataUtil.hanlerData((BpmProcessInstance)processInstance, (String)bto.getTaskKey(), (List)boDatas).get("hyywdx");
            data.put("taskId", bto.getTaskKey());
            insList.add(data);
        }
        pList.setPage(query.getPage());
        pList.setRows(insList);
        pList.setPageSize(query.getPageSize());
        pList.setTotal(query.getTotal());
        return pList;
    }

    @PostMapping(value={"/myCompletedJson"})
    @ApiOperation(value="\u5386\u53f2\u4f1a\u8bae", httpMethod="POST", notes="\u5386\u53f2\u4f1a\u8bae")
    public PageList<ObjectNode> myCompletedJson(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        queryFilter.addFilter("wfInst.PROC_DEF_KEY_", (Object)"hylc", QueryOP.EQUAL);
        queryFilter.addFilter("opinion.task_key_", (Object)"UserTask4", QueryOP.EQUAL);
        queryFilter.addFilter("opinion.auditor_", (Object)userId, QueryOP.EQUAL);
        PageList query = this.bpmProcessInstanceManager.getMyHandledMeeting(queryFilter);
        PageList pList = new PageList();
        ArrayList<ObjectNode> insList = new ArrayList<ObjectNode>();
        for (int i = 0; i < query.getRows().size(); ++i) {
            DefaultBpmProcessInstance processInstance = (DefaultBpmProcessInstance)query.getRows().get(i);
            List bpmTaskOpinions = this.bpmOpinionService.getTaskOpinions(processInstance.getId());
            Collections.sort(bpmTaskOpinions, new Comparator<BpmTaskOpinion>(){

                @Override
                public int compare(BpmTaskOpinion arg0, BpmTaskOpinion arg1) {
                    int hits0 = Integer.valueOf(arg0.getId());
                    int hits1 = Integer.valueOf(arg1.getId());
                    if (hits1 > hits0) {
                        return 1;
                    }
                    if (hits1 == hits0) {
                        return 0;
                    }
                    return -1;
                }
            });
            BpmTaskOpinion bto = (BpmTaskOpinion)bpmTaskOpinions.get(bpmTaskOpinions.size() - 1);
            List boDatas = this.boDataService.getDataByInst((BpmProcessInstance)processInstance);
            ObjectNode data = (ObjectNode)BoDataUtil.hanlerData((BpmProcessInstance)processInstance, (String)bto.getTaskKey(), (List)boDatas).get("hyywdx");
            data.put("taskId", bto.getTaskKey());
            insList.add(data);
        }
        pList.setRows(insList);
        pList.setPage((long)queryFilter.getPageBean().getPage().intValue());
        pList.setPageSize((long)queryFilter.getPageBean().getPageSize().intValue());
        pList.setTotal(query.getTotal());
        return pList;
    }

    @GetMapping(value={"/getBpmDefId/{id}"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0bkey\u83b7\u53d6\u6700\u65b0\u7684\u6d41\u7a0b\u5b9a\u4e49id", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0bkey\u83b7\u53d6\u6700\u65b0\u7684\u6d41\u7a0b\u5b9a\u4e49id")
    public String getBpmDefId(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        List defs = this.bpmDefinitionManager.queryByDefKey("hylc");
        String defId = "";
        if (defs.size() > 0 && BeanUtils.isNotEmpty(defs.get(defs.size() - 1))) {
            defId = ((DefaultBpmDefinition)defs.get(defs.size() - 1)).getDefId();
        }
        return defId;
    }
}

