package com.artfess.mdm.uc.model;

import com.artfess.base.entity.AutoOrgFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 组织机构表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2025-02-08
 */
@ApiModel(value="MdmOrgBasic对象", description="组织机构表")
@TableName("MDM_ORG_BASIC")
public class MdmOrgBasic extends AutoOrgFillModel<MdmOrgBasic> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择组织维度！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "组织维度ID")
    @TableField("DEM_ID_")
    private String demId;

    @NotBlank(message = "请填写组织名称！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "组织名称")
    @TableField("NAME_")
    private String name;

    @NotBlank(message = "请填写组织代码！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "组织代码(自编唯一值)")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "组织机构代码（国家组织唯一编码）")
    @TableField("ORG_CODE_")
    private String orgCode;

    @NotBlank(message = "请选择组织类别！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "组织类别（单位:OGN, 部门:DEPT）")
    @TableField("ORG_KIND_")
    private String orgKind;

    @NotBlank(message = "请选择父级组织！", groups = {UpdateGroup.class})
    @ApiModelProperty(value = "父组织ID")
    @TableField("PARENT_ID_")
    private String parentId;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "当前层级")
    @TableField("LEVEL_")
    private Integer level;

    @ApiModelProperty(value = "组织类型（1实体组织 2虚拟组织）")
    @TableField("ORG_TYPE_")
    private String orgType;

    @ApiModelProperty(value = "组织ID全路径，每层级用/分割")
    @TableField("PATH_ID_")
    private String pathId;

    @ApiModelProperty(value = "组织代码全路径，每层级用/分割")
    @TableField("PATH_CODE_")
    private String pathCode;

    @ApiModelProperty(value = "组织名称全路径，每层级用/分割")
    @TableField("PATH_NAME_")
    private String pathName;

    @ApiModelProperty(value = "组织限编用户数量(0:不受限制)")
    @TableField("LIMIT_NUM_")
    private Integer limitNum = 0;

    @ApiModelProperty(value = "组织现编用户数量")
    @TableField("NOW_NUM_")
    private Integer nowNum;

    @ApiModelProperty(value = "是否允许超过限编(0:允许；1:不允许)")
    @TableField("EXCEED_LIMIT_NUM_")
    private Integer exceedLimitNum = 0;

    @ApiModelProperty(value = "组织版本记录（可用使用年份来定义）")
    @TableField("ORG_VERSION_")
    private Integer orgVersion;

    @ApiModelProperty(value = "组织生效开始时间（用于每年组织变更时调整）")
    @TableField("ORG_START_DATE_")
    private LocalDate orgStartDate;

    @ApiModelProperty(value = "组织生效结束时间（默认9999-12-31）")
    @TableField("ORG_END_DATE_")
    private LocalDate orgEndDate;

    @ApiModelProperty(value = "最后操作时间")
    @TableField("LAST_OPERATE_TIME_")
    private LocalDateTime lastOperateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_SEQ_")
    private Long lastTimeSeq;

    @TableLogic
    @ApiModelProperty(value = "删除标志（0：已删除 1：未删除）")
    @TableField("IS_DELE_")
    private String isDele;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDemId() {
        return demId;
    }

    public void setDemId(String demId) {
        this.demId = demId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgKind() {
        return orgKind;
    }

    public void setOrgKind(String orgKind) {
        this.orgKind = orgKind;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getOrgType() {
        return orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    public String getPathId() {
        return pathId;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    public String getPathCode() {
        return pathCode;
    }

    public void setPathCode(String pathCode) {
        this.pathCode = pathCode;
    }

    public String getPathName() {
        return pathName;
    }

    public void setPathName(String pathName) {
        this.pathName = pathName;
    }

    public Integer getLimitNum() {
        return limitNum;
    }

    public void setLimitNum(Integer limitNum) {
        this.limitNum = limitNum;
    }

    public Integer getNowNum() {
        return nowNum;
    }

    public void setNowNum(Integer nowNum) {
        this.nowNum = nowNum;
    }

    public Integer getExceedLimitNum() {
        return exceedLimitNum;
    }

    public void setExceedLimitNum(Integer exceedLimitNum) {
        this.exceedLimitNum = exceedLimitNum;
    }

    public Integer getOrgVersion() {
        return orgVersion;
    }

    public void setOrgVersion(Integer orgVersion) {
        this.orgVersion = orgVersion;
    }

    public LocalDate getOrgStartDate() {
        return orgStartDate;
    }

    public void setOrgStartDate(LocalDate orgStartDate) {
        this.orgStartDate = orgStartDate;
    }

    public LocalDate getOrgEndDate() {
        return orgEndDate;
    }

    public void setOrgEndDate(LocalDate orgEndDate) {
        this.orgEndDate = orgEndDate;
    }

    public LocalDateTime getLastOperateTime() {
        return lastOperateTime;
    }

    public void setLastOperateTime(LocalDateTime lastOperateTime) {
        this.lastOperateTime = lastOperateTime;
    }

    public Long getLastTimeSeq() {
        return lastTimeSeq;
    }

    public void setLastTimeSeq(Long lastTimeSeq) {
        this.lastTimeSeq = lastTimeSeq;
    }


    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "MdmOrgBasic{" +
            "id=" + id +
            ", demId=" + demId +
            ", name=" + name +
            ", code=" + code +
            ", orgCode=" + orgCode +
            ", orgKind=" + orgKind +
            ", parentId=" + parentId +
            ", sn=" + sn +
            ", level=" + level +
            ", orgType=" + orgType +
            ", pathId=" + pathId +
            ", pathCode=" + pathCode +
            ", pathName=" + pathName +
            ", limitNum=" + limitNum +
            ", nowNum=" + nowNum +
            ", exceedLimitNum=" + exceedLimitNum +
            ", orgVersion=" + orgVersion +
            ", orgStartDate=" + orgStartDate +
            ", orgEndDate=" + orgEndDate +
            ", lastOperateTime=" + lastOperateTime +
            ", lastTimeSeq=" + lastTimeSeq +
            ", isDele=" + isDele +
        "}";
    }
}
