/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activemq.consumer;

import com.artfess.activemq.model.JmsSysTypeChangeMessage;
import com.artfess.activemq.model.JmsTableTypeConf;
import com.artfess.activemq.model.JmsTableTypeFiledDetail;
import com.artfess.base.context.BaseContext;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ExceptionUtil;
import com.artfess.base.util.StringUtil;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"jms.enable"}, matchIfMissing=true)
public class JmsSysTypeChangeConsumer {
    private static final Logger logger = LoggerFactory.getLogger(JmsSysTypeChangeConsumer.class);
    @Resource
    CommonManager commonManager;
    @Resource
    BaseContext baseContext;

    @JmsListener(destination="${jms.topic.name:eipTopic}", containerFactory="jmsListenerContainerTopic")
    public void receiveQueue(Object model) throws JMSException {
        logger.debug("[JMS]: Topic message is :" + model.getClass().getName() + "---" + model);
        this.handlerSysTypeChange(model);
    }

    private void handlerSysTypeChange(Object source) throws JMSException {
        if (BeanUtils.isEmpty((Object)source) || !(source instanceof ObjectMessage)) {
            return;
        }
        ObjectMessage message = (ObjectMessage)source;
        Serializable object = message.getObject();
        if (!(object instanceof JmsSysTypeChangeMessage)) {
            return;
        }
        JmsSysTypeChangeMessage type = (JmsSysTypeChangeMessage)object;
        try {
            if (StringUtil.isNotEmpty((String)type.getTypeGroupKey()) && JmsTableTypeConf.getTypeConf().containsKey(type.getTypeGroupKey().toUpperCase())) {
                List<JmsTableTypeFiledDetail> detailList = JmsTableTypeConf.getTypeConf().get(type.getTypeGroupKey());
                for (JmsTableTypeFiledDetail jmsTableTypeFiledDetail : detailList) {
                    this.chanegType(type, jmsTableTypeFiledDetail);
                }
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.getExceptionMessage((Throwable)e));
        }
    }

    private void chanegType(JmsSysTypeChangeMessage type, JmsTableTypeFiledDetail detail) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("UPDATE ").append(detail.getTableName()).append(" set ");
        if (2 == type.getOpType()) {
            if (StringUtil.isNotEmpty((String)detail.getTypeIdFiledName())) {
                sqlSb.append(detail.getTypeIdFiledName()).append(" = ''");
            }
            type.setTypeName("");
        } else if (3 == type.getOpType() && StringUtil.isNotEmpty((String)detail.getTypeIdFiledName())) {
            sqlSb.append(detail.getTypeIdFiledName()).append(" = '");
            sqlSb.append(type.getTypeId()).append("'");
        }
        if (StringUtil.isNotEmpty((String)detail.getTypeNameFiledName())) {
            if (StringUtil.isNotEmpty((String)detail.getTypeIdFiledName()) && 1 != type.getOpType()) {
                sqlSb.append(",");
            }
            sqlSb.append(detail.getTypeNameFiledName()).append(" = '").append(type.getTypeName());
        }
        sqlSb.append("' where ");
        if (BeanUtils.isNotEmpty((Object)type.getTenantId())) {
            MultiTenantHandler.setThreadLocalIgnore();
            sqlSb.append(detail.getTableName() + ".tenant_id_='" + type.getTenantId() + "' and ");
        }
        if (3 == type.getOpType() && StringUtil.isNotEmpty((String)detail.getPkFiledName())) {
            sqlSb.append(detail.getPkFiledName()).append(" in ('").append(StringUtil.join((String[])type.getEntityIds().split(","), (String)"','")).append("')");
            this.commonManager.execute(sqlSb.toString());
        } else if (StringUtil.isNotEmpty((String)detail.getTypeIdFiledName())) {
            sqlSb.append(detail.getTypeIdFiledName()).append("='").append(type.getTypeId()).append("'");
            this.commonManager.execute(sqlSb.toString());
        } else if (StringUtil.isNotEmpty((String)detail.getTypeNameFiledName())) {
            sqlSb.append(detail.getTypeNameFiledName()).append("='").append(type.getOldTypeName()).append("'");
            this.commonManager.execute(sqlSb.toString());
        }
    }
}

