import req from "@/request.js";

const portal = window.context.portal;
export default {
   //分页
	dataQuery(data, cb) {
		req.post(portal + `/base/team/member/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 新增
	addSave(data, cb) {
		req.post(portal + `/base/team/member/`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 修改
	detailId(id, cb) {
		req.get(portal + `/base/team/member/${id}`).then(rep => {
			cb(rep.data);
		});
	},
	// 确认修改
	upData(data, cb) {
		req.put(portal + `/base/team/member/`, data).then(rep => {
			cb(rep.data);
		});
	},
	//批量删除
    batchRemove(ids,cb) {
        req.remove(portal + `/base/team/member/?ids=`+ids).then(rep => {
            cb(rep.data);
        });
    },
	//删除
	remove(id,cb) {
	    req.remove(portal + `/base/team/member/${id}`).then(rep => {
	        cb(rep.data);
	    });
	},
	// 导出
	exportFile(data, cb) {
		req.post(portal + `/base/team/member/export`, data, 'blob').then(res => {
			cb(res.data)
		})
	},
}