import req from "@/request.js";

const portal = window.context.portal;
export default {
   //分页
	dataQuery(data, cb) {
		req.post(portal + `/base/deviceInfo/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 新增
	addSave(data, cb) {
		req.post(portal + `/base/deviceInfo/`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 修改
	detailId(id, cb) {
		req.get(portal + `/base/deviceInfo/${id}`).then(rep => {
			cb(rep.data);
		});
	},
	// 确认修改
	upData(data, cb) {
		req.put(portal + `/base/deviceInfo/`, data).then(rep => {
			cb(rep.data);
		});
	},
	//删除
	remove(id,cb) {
	    req.remove(portal + `/base/deviceInfo/${id}`).then(rep => {
	        cb(rep.data);
	    });
	},
	//噪音分类树
	plazaQuery(data, cb) {
		req.post(portal + `/base/square/location/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 获取不同类型的设备列表
	getDeviceList(id, cb) {
		req.get(portal + `/base/deviceInfo/getDeviceList?deviceCode=${id}`).then(rep => {
			cb(rep.data);
		});
	},
}