// let host = window.location.protocol+"//"+window.location.hostname;
// 当前后端不在同一个服务器时，需要指定host地址 host为后端接口地址
let host = 'http://183.230.176.125' //公司

// 前端部署访问地址，用于静态文件访问，路径跳转等
let onlineFront = 'http://183.230.176.125'

// combine为true时五合一部署, 为false时分五个服务部署
let combine = true
var defaultModulePortMap = {
  form: '8082',
  portal: '8084', //sysconfig
  application: '8085',
  bpmRunTime: '8086',
  bpmModel: '8087',
  uc: '8088',
  cssc: '8089'
}

window.getModuleRootUrl = function(module) {
  // 默认是全部服务合一的端口
  var modulePort = '18068' // 轻纺

  if (!combine) {
    modulePort = defaultModulePortMap[module]
  }
  return host + ':' + modulePort
}

window.context = {
  manage: host + ':19088/mvue', // 管理端页面
  front: host + ':19088/fvue', //前端页面

  report: host + ':8098/', // 数据报表接口
  mobile: host + ':8082/mobilevue', //手机端页面
  WebSocket: host + ':8099', //websocket
  application: getModuleRootUrl('application'),
  form: getModuleRootUrl('form'),
  portal: getModuleRootUrl('portal'),
  bpmRunTime: getModuleRootUrl('bpmRunTime'),
  bpmModel: getModuleRootUrl('bpmModel'),
  uc: getModuleRootUrl('uc'),
  mc: getModuleRootUrl('mc'),
  cssc: getModuleRootUrl('cssc')
}

// 单点配置
window.ssoConfig = {
  mode: '', // 空则不使用单点  支持的模式有  cas oauth basic
  url: 'http://192.168.1.115:8093/oauth/authorize',
  clientId: 'eip7', // oauth模式下需要提供
  logout: 'http://192.168.1.115:8093/logout'
}
