/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.KpiTargetTypeEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationKpiMDao;
import com.artfess.cqlt.manager.QfOperationKpiDManager;
import com.artfess.cqlt.manager.QfOperationKpiMManager;
import com.artfess.cqlt.model.QfOperationKpiD;
import com.artfess.cqlt.model.QfOperationKpiM;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfOperationKpiMManagerImpl
extends BaseManagerImpl<QfOperationKpiMDao, QfOperationKpiM>
implements QfOperationKpiMManager {
    private static final Logger log = LoggerFactory.getLogger(QfOperationKpiMManagerImpl.class);
    @Autowired
    private QfOperationKpiDManager operationKpiDManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfOperationKpiD> list, String mainId) {
        QfOperationKpiM qfOperationKpiM = (QfOperationKpiM)((Object)((QfOperationKpiMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)qfOperationKpiM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(qfOperationKpiM.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.operationKpiDManager.remove((Wrapper)queryWrapper);
        ArrayList newList = Lists.newArrayList();
        list.forEach(detail -> {
            if (StringUtils.isEmpty((Object)detail.getEnterpriseCode())) {
                return;
            }
            detail.setMainId(mainId);
            detail.setFillDate(qfOperationKpiM.getFillDate());
            newList.add(detail);
        });
        boolean b = this.operationKpiDManager.saveBatch(newList);
        return b;
    }

    @Override
    public boolean updateStatus(QfOperationKpiM t) {
        QfOperationKpiM qfOperationKpiM = (QfOperationKpiM)((Object)((QfOperationKpiMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == qfOperationKpiM) {
            return false;
        }
        qfOperationKpiM.setStatus(qfOperationKpiM.getStatus() == 0 ? 1 : 0);
        int i = ((QfOperationKpiMDao)this.baseMapper).updateById((Object)qfOperationKpiM);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfOperationKpiM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List qfOperationKpiMS = ((QfOperationKpiMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationKpiMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfOperationKpiM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List qfOperationKpiMS = ((QfOperationKpiMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationKpiMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    public List<FaTargetRespVo> data(ReportReqVo t) {
        List<QfOperationKpiD> list;
        if (null == t.getYear() || t.getYear() <= 0) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 5);
        }
        if (!StringUtils.isEmpty((Object)t.getEnterpriseCode()) && "CIGR".equals(t.getEnterpriseCode())) {
            t.setEnterpriseCode(null);
        }
        if (CollectionUtils.isEmpty(list = ((QfOperationKpiMDao)this.baseMapper).data(t))) {
            return Lists.newArrayList();
        }
        ArrayList data = Lists.newArrayList();
        for (int i = 1; i <= 7; ++i) {
            this.processTrAct(data, list, KpiTargetTypeEnum.getTarget((Integer)i));
        }
        return data;
    }

    private void processTrAct(List<FaTargetRespVo> data, List<QfOperationKpiD> detailList, KpiTargetTypeEnum kpiTargetTypeEnum) {
        FaTargetRespVo resultFa = new FaTargetRespVo();
        resultFa.setTargetName(kpiTargetTypeEnum.getTargetName());
        resultFa.setTargetNameEn(kpiTargetTypeEnum.getTargetNameEn());
        resultFa.setTargetUnit(kpiTargetTypeEnum.getTargetUnit());
        resultFa.setTargetId(kpiTargetTypeEnum.getTargetId());
        resultFa.setStaLat("1");
        resultFa.setType("1");
        Map<Integer, QfOperationKpiD> monthData = detailList.stream().filter(b -> !StringUtils.isEmpty((Object)b.getFillMonth())).collect(Collectors.toMap(item -> item.getFillMonth(), item -> item));
        ArrayList reportRespVos = Lists.newArrayList();
        FaTargetRespVo finalResultFa = resultFa;
        ArrayList finalReportRespVos = reportRespVos;
        monthData.forEach((month, detail) -> {
            BigDecimal fillData = BigDecimal.ZERO;
            fillData = this.getFillData(kpiTargetTypeEnum, (QfOperationKpiD)((Object)detail), fillData);
            FaReportRespVo faReportRespVo = new FaReportRespVo();
            faReportRespVo.setMonth((Integer)month);
            faReportRespVo.setActual(fillData);
            finalReportRespVos.add(faReportRespVo);
            finalResultFa.setResultData(finalReportRespVos);
        });
        data.add(resultFa);
    }

    private BigDecimal getFillData(KpiTargetTypeEnum kpiTargetTypeEnum, QfOperationKpiD detail, BigDecimal fillData) {
        if (kpiTargetTypeEnum.getType().equals(KpiTargetTypeEnum.hr_acr_act_quantity_.getType())) {
            fillData = detail.getHrAcrActQuantity();
        }
        if (kpiTargetTypeEnum.getType().equals(KpiTargetTypeEnum.tr_exfi_act_.getType())) {
            fillData = detail.getTrExfiAct();
        }
        if (kpiTargetTypeEnum.getType().equals(KpiTargetTypeEnum.oee24_ex_epdm_act_.getType())) {
            fillData = detail.getOee24ExEpdmAct();
        }
        if (kpiTargetTypeEnum.getType().equals(KpiTargetTypeEnum.crj_exfi_act_.getType())) {
            fillData = detail.getCrjExfiAct();
        }
        if (kpiTargetTypeEnum.getType().equals(KpiTargetTypeEnum.cc_exfi_act_.getType())) {
            fillData = detail.getCcExfiAct();
        }
        if (kpiTargetTypeEnum.getType().equals(KpiTargetTypeEnum.qr_ex_epdm_act_.getType()) && null != detail.getQrExEpdmAct()) {
            fillData = new BigDecimal(100).subtract(detail.getQrExEpdmAct());
        }
        if (kpiTargetTypeEnum.getType().equals(KpiTargetTypeEnum.hr_et_rate_bud_.getType())) {
            fillData = detail.getHrEtDirAct();
        }
        if (null != fillData) {
            fillData = fillData.setScale(2, 5);
        }
        return fillData;
    }

    @Override
    public List<FaTargetRespVo> fromUnderData(ReportReqVo t) {
        List<QfOperationKpiD> monthData;
        List<QfOperationKpiD> quarterData;
        List<QfOperationKpiD> yearData;
        Assert.hasText((String)t.getTargetId(), (String)"\u8bf7\u9009\u62e9\u8981\u7edf\u8ba1\u7684\u6307\u6807id");
        KpiTargetTypeEnum kpiTargetTypeEnum = KpiTargetTypeEnum.findByTargetId((String)t.getTargetId());
        ArrayList resultList = Lists.newArrayList();
        if (null == t.getYear() || t.getYear() <= 0) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 10);
        }
        if (null == t.getStartQuarter() || null == t.getEndQuarter()) {
            t.setEndQuarter(4);
            t.setStartQuarter(1);
        }
        if (null == t.getStartMonth() || null == t.getEndMonth()) {
            t.setYear(t.getQuarterYear());
            t.setEndMonth(12);
            t.setStartMonth(1);
        }
        if (!CollectionUtils.isEmpty(yearData = ((QfOperationKpiMDao)this.baseMapper).yearData(t))) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setTargetName(kpiTargetTypeEnum.getTargetName());
            resultFa.setTargetNameEn(kpiTargetTypeEnum.getTargetNameEn());
            resultFa.setTargetUnit(kpiTargetTypeEnum.getTargetUnit());
            resultFa.setTargetId(kpiTargetTypeEnum.getTargetId());
            resultFa.setStaLat("1");
            resultFa.setType("2");
            ArrayList reportRespVos = Lists.newArrayList();
            yearData.forEach(detail -> {
                BigDecimal fillData = BigDecimal.ZERO;
                fillData = this.getFillData(kpiTargetTypeEnum, (QfOperationKpiD)((Object)detail), fillData);
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                faReportRespVo.setYear(detail.getFillYear());
                faReportRespVo.setActual(fillData);
                reportRespVos.add(faReportRespVo);
            });
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        if (!CollectionUtils.isEmpty(quarterData = ((QfOperationKpiMDao)this.baseMapper).quarterData(t))) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setTargetName(kpiTargetTypeEnum.getTargetName());
            resultFa.setTargetNameEn(kpiTargetTypeEnum.getTargetNameEn());
            resultFa.setTargetUnit(kpiTargetTypeEnum.getTargetUnit());
            resultFa.setTargetId(kpiTargetTypeEnum.getTargetId());
            resultFa.setStaLat("1");
            resultFa.setType("3");
            ArrayList reportRespVos = Lists.newArrayList();
            quarterData.forEach(detail -> {
                BigDecimal fillData = BigDecimal.ZERO;
                fillData = this.getFillData(kpiTargetTypeEnum, (QfOperationKpiD)((Object)detail), fillData);
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                faReportRespVo.setMonth(detail.getFillMonth());
                faReportRespVo.setActual(fillData);
                reportRespVos.add(faReportRespVo);
            });
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        if (!CollectionUtils.isEmpty(monthData = ((QfOperationKpiMDao)this.baseMapper).monthData(t))) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setTargetName(kpiTargetTypeEnum.getTargetName());
            resultFa.setTargetNameEn(kpiTargetTypeEnum.getTargetNameEn());
            resultFa.setTargetUnit(kpiTargetTypeEnum.getTargetUnit());
            resultFa.setTargetId(kpiTargetTypeEnum.getTargetId());
            resultFa.setStaLat("1");
            resultFa.setType("4");
            ArrayList reportRespVos = Lists.newArrayList();
            monthData.forEach(detail -> {
                BigDecimal fillData = BigDecimal.ZERO;
                fillData = this.getFillData(kpiTargetTypeEnum, (QfOperationKpiD)((Object)detail), fillData);
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                faReportRespVo.setMonth(detail.getFillMonth());
                faReportRespVo.setActual(fillData);
                reportRespVos.add(faReportRespVo);
            });
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        return resultList;
    }

    @Override
    public List<FaReportRespVo> enterpriseData(ReportReqVo t) {
        Assert.hasText((String)t.getTargetId(), (String)"\u8bf7\u9009\u62e9\u8981\u7edf\u8ba1\u7684\u6307\u6807id");
        int year = LocalDate.now().getYear();
        t.setYear(year);
        List<QfOperationKpiD> faReportRespVos = ((QfOperationKpiMDao)this.baseMapper).enterpriseData(t);
        KpiTargetTypeEnum kpiTargetTypeEnum = KpiTargetTypeEnum.findByTargetId((String)t.getTargetId());
        if (!CollectionUtils.isEmpty(faReportRespVos)) {
            ArrayList reportRespVos = Lists.newArrayList();
            faReportRespVos.forEach(detail -> {
                BigDecimal fillData = BigDecimal.ZERO;
                fillData = this.getFillData(kpiTargetTypeEnum, (QfOperationKpiD)((Object)detail), fillData);
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                faReportRespVo.setYear(detail.getFillYear());
                faReportRespVo.setActual(fillData);
                faReportRespVo.setEnterpriseCode(detail.getEnterpriseCode());
                reportRespVos.add(faReportRespVo);
            });
            return reportRespVos;
        }
        return Lists.newArrayList();
    }
}

