/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfFinanceLoanDDao;
import com.artfess.cqlt.dao.QfFinanceLoanMDao;
import com.artfess.cqlt.manager.QfFinanceLoanDManager;
import com.artfess.cqlt.model.QfFinanceLoanD;
import com.artfess.cqlt.model.QfFinanceLoanM;
import com.artfess.cqlt.vo.BankLoanDetailRespVo;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.MoneyReportRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.artfess.i18n.util.I18nUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class QfFinanceLoanDManagerImpl
extends BaseManagerImpl<QfFinanceLoanDDao, QfFinanceLoanD>
implements QfFinanceLoanDManager {
    @Resource
    private QfFinanceLoanMDao loanMDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfFinanceLoanM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfFinanceLoanM QfFinanceLoanM2 = (QfFinanceLoanM)((Object)this.loanMDao.selectById((Serializable)((Object)t.getId())));
        Assert.notNull((Object)((Object)QfFinanceLoanM2), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(QfFinanceLoanM2.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        List<QfFinanceLoanD> list = t.getList();
        list.forEach(detail -> {
            detail.setMainId(t.getId());
            detail.setFillDate(QfFinanceLoanM2.getFillDate());
        });
        boolean b = this.saveOrUpdateBatch(list);
        return b;
    }

    @Override
    public List<MoneyReportRespVo> cqltSgYearData(ReportReqVo t) {
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 10);
        }
        return ((QfFinanceLoanDDao)this.baseMapper).cqltSgYearData(t);
    }

    @Override
    public List<MoneyReportRespVo> cqltSgQuarterData(ReportReqVo t) {
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartQuarter() || null == t.getEndQuarter()) {
            t.setEndQuarter(4);
            t.setStartQuarter(1);
        }
        return ((QfFinanceLoanDDao)this.baseMapper).cqltSgQuarterData(t);
    }

    @Override
    public List<MoneyReportRespVo> sgYearData(ReportReqVo t) {
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 10);
        }
        return ((QfFinanceLoanDDao)this.baseMapper).sgYearData(t);
    }

    @Override
    public List<MoneyReportRespVo> sgQuarterData(ReportReqVo t) {
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartQuarter() || null == t.getEndQuarter()) {
            t.setEndQuarter(4);
            t.setStartQuarter(1);
        }
        return ((QfFinanceLoanDDao)this.baseMapper).sgQuarterData(t);
    }

    @Override
    public List<FaReportRespVo> nbwdYearAnalysis(ReportReqVo t) {
        return ((QfFinanceLoanDDao)this.baseMapper).nbwdYearAnalysis(t);
    }

    @Override
    public List<FaReportRespVo> zzrzYearAnalysis(ReportReqVo t) {
        return ((QfFinanceLoanDDao)this.baseMapper).zzrzYearAnalysis(t);
    }

    @Override
    public List<FaReportRespVo> dbzeQuarterCompanyAnalysis(ReportReqVo t) {
        return ((QfFinanceLoanDDao)this.baseMapper).dbzeQuarterCompanyAnalysis(t);
    }

    @Override
    public List<FaReportRespVo> dkyeQuarterCompanyAnalysis(ReportReqVo t, String dataType) {
        return ((QfFinanceLoanDDao)this.baseMapper).dkyeQuarterCompanyAnalysis(t, dataType);
    }

    @Override
    public List<BankLoanDetailRespVo> bankDetail(ReportReqVo t, String dataType) {
        return ((QfFinanceLoanDDao)this.baseMapper).bankDetail(t, dataType);
    }

    @Override
    public BigDecimal getEarlyGuaranteeMoney(Integer year) {
        return ((QfFinanceLoanDDao)this.baseMapper).getEarlyGuaranteeMoney(year);
    }

    @Override
    public List<FaReportRespVo> bankAnnualFigure(ReportReqVo t, String dataType) {
        return ((QfFinanceLoanDDao)this.baseMapper).bankAnnualFigure(t, dataType);
    }
}

