/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqlt.dao.QfFinanceReportingSummaryMDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfFinanceReportingSummaryDManager;
import com.artfess.cqlt.manager.QfFinanceReportingSummaryMManager;
import com.artfess.cqlt.manager.QfFinanceReportingSummarySManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceReportingSummaryD;
import com.artfess.cqlt.model.QfFinanceReportingSummaryM;
import com.artfess.cqlt.model.QfFinanceReportingSummaryS;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinanceReportingSummaryMManagerImpl
extends BaseManagerImpl<QfFinanceReportingSummaryMDao, QfFinanceReportingSummaryM>
implements QfFinanceReportingSummaryMManager {
    private static final Logger log = LoggerFactory.getLogger(QfFinanceReportingSummaryMManagerImpl.class);
    @Autowired
    private QfFinanceReportingSummaryDManager financeReportingSummaryDManager;
    @Autowired
    private QfFinanceReportingSummarySManager financeReportingSummarySManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(QfFinanceReportingSummaryM t) {
        QfFinanceReportingSummaryM QfFinanceReportingSummaryM2 = (QfFinanceReportingSummaryM)((Object)((QfFinanceReportingSummaryMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfFinanceReportingSummaryM2) {
            return false;
        }
        QfFinanceReportingSummaryM2.setStatus(QfFinanceReportingSummaryM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfFinanceReportingSummaryMDao)this.baseMapper).updateById((Object)QfFinanceReportingSummaryM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<HeaderNode> list, String mainId) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        QfFinanceReportingSummaryM mainInfo = (QfFinanceReportingSummaryM)((Object)((QfFinanceReportingSummaryMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)mainInfo), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(mainInfo.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        List<HeaderNode> headerNodeList = list.stream().collect(Collectors.groupingBy(HeaderNode::getRow)).get(0);
        HashMap headerMap = Maps.newHashMap();
        for (HeaderNode headerNode : headerNodeList) {
            headerMap.put(headerNode.getColumn(), headerNode.getHeaderName());
        }
        Map<Integer, List<HeaderNode>> detailMap = list.stream().collect(Collectors.groupingBy(HeaderNode::getColumn));
        List<HeaderNode> subjectCodes = detailMap.get(1);
        HashMap subjectCodeMap = Maps.newHashMap();
        for (HeaderNode headerNode : subjectCodes) {
            subjectCodeMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }
        List<HeaderNode> subjectNameEns = detailMap.get(0);
        HashMap subjectNameEnsMap = Maps.newHashMap();
        for (HeaderNode headerNode : subjectNameEns) {
            subjectNameEnsMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }
        int maxColumn = detailMap.size();
        ArrayList detailList = Lists.newArrayList();
        JSONObject totalInfo = new JSONObject();
        for (Map.Entry<Integer, List<HeaderNode>> entry : detailMap.entrySet()) {
            Integer column = entry.getKey();
            List<HeaderNode> nodes = entry.getValue();
            String enterpriseCode = (String)headerMap.get(column);
            for (HeaderNode node : nodes) {
                if (0 == node.getRow()) continue;
                String subjectCode = (String)subjectCodeMap.get(node.getRow());
                if (node.getColumn() > 1 && node.getColumn() < maxColumn - 3 && !StringUtils.isEmpty((Object)node.getHeaderName())) {
                    this.createDetail(mainInfo, enterpriseInfoMap, subjectCodeMap, subjectNameEnsMap, detailList, enterpriseCode, node);
                    continue;
                }
                if (node.getColumn() < maxColumn - 3 || StringUtils.isEmpty((Object)node.getHeaderName())) continue;
                if (node.getColumn() == maxColumn - 1) {
                    totalInfo.put(subjectCode + ":actualConsolidated", (Object)node.getHeaderName());
                    continue;
                }
                if (node.getColumn() == maxColumn - 2) {
                    totalInfo.put(subjectCode + ":actualPosting", (Object)node.getHeaderName());
                    continue;
                }
                if (node.getColumn() != maxColumn - 3) continue;
                totalInfo.put(subjectCode + ":actualTotal", (Object)node.getHeaderName());
            }
        }
        List<QfFinanceReportingSummaryS> totalList = this.createTotalInfo(mainInfo, subjectCodeMap, subjectNameEnsMap, totalInfo);
        this.financeReportingSummarySManager.saveBatch(totalList);
        try {
            this.partitionSave(detailList);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u4f8b\u5982\u62a5\u8868\u6570\u636e\u5931\u8d25:{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private List<QfFinanceReportingSummaryS> createTotalInfo(QfFinanceReportingSummaryM mainInfo, Map<Integer, String> subjectCodeMap, Map<Integer, String> subjectNameEnsMap, JSONObject totalInfo) {
        ArrayList totalList = Lists.newArrayList();
        subjectCodeMap.forEach((row, subjectCode) -> {
            QfFinanceReportingSummaryS summaryS = new QfFinanceReportingSummaryS();
            summaryS.setMainId(mainInfo.getId());
            summaryS.setSubjectNameEn((String)subjectNameEnsMap.get(row));
            summaryS.setSubjectUnit("\u6b27\u5143");
            summaryS.setSubjectCode((String)subjectCode);
            if (totalInfo.containsKey((Object)(subjectCode + ":actualConsolidated"))) {
                summaryS.setActualConsolidated(totalInfo.getBigDecimal(subjectCode + ":actualConsolidated"));
            }
            if (totalInfo.containsKey((Object)(subjectCode + ":actualPosting"))) {
                summaryS.setActualPosting(totalInfo.getBigDecimal(subjectCode + ":actualPosting"));
            }
            if (totalInfo.containsKey((Object)(subjectCode + ":actualTotal"))) {
                summaryS.setActualTotal(totalInfo.getBigDecimal(subjectCode + ":actualTotal"));
            }
            summaryS.setFillYear(mainInfo.getFillYear());
            summaryS.setFillMonth(mainInfo.getFillMonth());
            summaryS.setFillDate(mainInfo.getFillDate());
            summaryS.setFillQuarter(mainInfo.getFillQuarter());
            summaryS.setSubjectCode((String)subjectCode);
            totalList.add(summaryS);
        });
        return totalList;
    }

    private void partitionSave(List<QfFinanceReportingSummaryD> detailList) throws InterruptedException {
        List partition = BeanUtils.partition(detailList, (int)(detailList.size() / 10));
        ExecutorService executorService = Executors.newFixedThreadPool(partition.size());
        CountDownLatch countDownLatch = new CountDownLatch(partition.size());
        int i = 0;
        while (i < partition.size()) {
            int finalI = i++;
            executorService.execute(() -> {
                List importParamDTOList = (List)partition.get(finalI);
                this.financeReportingSummaryDManager.saveOrUpdateBatch(importParamDTOList);
                countDownLatch.countDown();
            });
        }
        countDownLatch.await();
        executorService.shutdown();
    }

    private void createDetail(QfFinanceReportingSummaryM mainInfo, Map<String, QfEnterpriseInfo> enterpriseInfoMap, Map<Integer, String> subjectCodeMap, Map<Integer, String> subjectNameEnsMap, List<QfFinanceReportingSummaryD> detailList, String enterpriseCode, HeaderNode node) {
        QfFinanceReportingSummaryD detail = new QfFinanceReportingSummaryD();
        detail.setMainId(mainInfo.getId());
        detail.setSn(node.getRow());
        detail.setColumn(node.getColumn());
        detail.setFillDate(mainInfo.getFillDate());
        detail.setEnterpriseCode(enterpriseCode);
        detail.setSubjectCode(subjectCodeMap.get(node.getRow()));
        detail.setSubjectNameEn(subjectNameEnsMap.get(node.getRow()));
        detail.setActualYtd(new BigDecimal(node.getHeaderName()));
        if (enterpriseInfoMap.containsKey(detail.getEnterpriseCode())) {
            QfEnterpriseInfo qfEnterpriseInfo = enterpriseInfoMap.get(detail.getEnterpriseCode());
            detail.setEnterpriseName(qfEnterpriseInfo.getName());
            detail.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
        }
        detailList.add(detail);
    }

    @Override
    public void removeInfo(String mainId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.financeReportingSummaryDManager.remove((Wrapper)queryWrapper);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_id_", (Object)mainId);
        this.financeReportingSummarySManager.remove((Wrapper)query);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfFinanceReportingSummaryM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfFinanceReportingSummaryMS = ((QfFinanceReportingSummaryMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceReportingSummaryMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceReportingSummaryMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfFinanceReportingSummaryM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfFinanceReportingSummaryMS = ((QfFinanceReportingSummaryMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceReportingSummaryMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceReportingSummaryMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }
}

