import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增安全培训记录
  addCmgtSaftyTrainingRecord(data, cb) {
    req.post(portal + `/manager/cmgtSaftyTrainRecord/create`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改安全培训记录
  editCmgtSaftyTrainingRecord(data, cb) {
    req.put(portal + `/manager/cmgtSaftyTrainRecord/updateById`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询安全培训记录
  loadCmgtSaftyTrainingRecord(data, cb) {
    req.post(portal + `/manager/cmgtSaftyTrainRecord/query`, data).then(res => {
      cb(res.data)
    })
  },
      // 根据id查询实体
  cmgtWorkWarnSendDetailId(data, cb) {
    req.get(portal + `/manager/cmgtSaftyTrainRecord/`+data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除安全培训记录
  deleteCmgtSaftyTrainingRecord(data) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/manager/cmgtSaftyTrainRecord/delete?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
}
