import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增安全工作目标信息
  addCmgtSaftyTarget(data, cb) {
    req.post(portal + `/manager/cmgtSaftyTarget/create`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改安全工作目标信息
  editCmgtSaftyTarget(data, cb) {
    req.put(portal + `/manager/cmgtSaftyTarget/updateById`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询安全工作目标信息
  loadCmgtSaftyTarget(data, cb) {
    req.post(portal + `/manager/cmgtSaftyTarget/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除安全工作目标信息
  deleteCmgtSaftyTarget(data, cb) {
    req.remove(portal + `/manager/cmgtSaftyTarget/delete`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询
  getItemById(id, cb) {
    req.get(portal + `/manager/cmgtSaftyTarget/` + id).then(res => {
      cb(res.data)
    })
  },
}
