import req from '@/request.js'

const portal = window.context.portal
export default {
  //获取列表数据(安全检查记录（日常）)
  CmgTSaftyCheckRecordList(data, cb) {
    req.post(portal + `/cmgtSafeCheckDaily/v1/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 新增接口
  addAction(data, cb) {
    req.post(portal + `/cmgtSafeCheckDaily/v1/`, data).then(res => {
      cb(res.data)
    })
  },
  editCmgtSaftyTarget(data, cb) {
    req.put(portal + `/cmgtSafeCheckDaily/v1/`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除
  deleteCmgtSaftyHC(data, cb) {
    req.remove(portal + `/cmgtSafeCheckDaily/v1/delete/ids`, data).then(res => {
      cb(res.data)
    })
  },
  getItemById(id, cb) {
    req.get(portal + `/cmgtSafeCheckDaily/v1/` + id).then(res => {
      cb(res.data)
    })
  }
}
