import req from '@/request.js'

const portal = window.context.portal
export default {
  // 新增安全隐患排查记录
  addCmgtSaftyDangerCheckrecord(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerCheckrecord/create`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改安全隐患排查记录
  editCmgtSaftyDangerCheckrecord(data, cb) {
    req.put(portal + `/manager/cmgtSaftyDangerCheckrecord/updateById`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询安全隐患排查记录
  loadCmgtSaftyDangerCheckrecord(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerCheckrecord/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除安全隐患排查记录
  deleteCmgtSaftyDangerCheckrecord(data, cb) {
    req.remove(portal + `/manager/cmgtSaftyDangerCheckrecord/delete?ids=` + data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询
  getItemById(id, cb) {
    req.get(portal + `/manager/cmgtSaftyDangerCheckrecord/` + id).then(res => {
      cb(res.data)
    })
  },
  // 排查方案根据id查询
  cmgtSaftyDangerCheckschemeId(id, cb) {
    req.get(portal + `/manager/cmgtSaftyDangerCheckscheme/` + id).then(res => {
      cb(res.data)
    })
  },
  // 安全隐患排查对象根据id查询
  cmgtSaftyDangerUnitId(id, cb) {
    req.get(portal + `/manager/cmgtSaftyDangerUnit/` + id).then(res => {
      cb(res.data)
    })
  },

  // 复查
  CSaftyDangerAbarbeitungReview(data, cb) {
    req.post(portal + `/manager/CSaftyDangerAbarbeitung/review`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除隐患
  CSaftyDangerAbarbeitungDelete(data) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/manager/cmgtSaftyDangerCheckrecordDetail/delete?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 关闭隐患
  CSaftyDangerAbarbeitungClose(data) {
    console.log(data)
    return new Promise((resolve, reject) => {
      req.post(portal + `/manager/CSaftyDangerAbarbeitung/close?detailIds=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 分页查询隐患治理整改
  CSaftyDangerAbarbeitungList(data) {
    return req.post(portal + `/manager/CSaftyDangerAbarbeitung/list`, data)
  },

  // 新增子表
  CSaftyDangerCheckrecordDetailCreate(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerCheckrecordDetail/create`, data).then(res => {
      cb(res.data)
    })
  },

  // 修改子表
  CSaftyDangerCheckrecordDetailUpdateById(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerCheckrecordDetail/updateById`, data).then(res => {
      cb(res.data)
    })
  },

  // 删除子表
  CSaftyDangerCheckrecordDetailDelete(ids, cb) {
    req.get(portal + `/manager/cmgtSaftyDangerCheckrecordDetail/delete?ids=` + ids).then(res => {
      cb(res.data)
    })
  },

  // 通过id查询子表
  CSaftyDangerCheckrecordDetailById(id, cb) {
    req.get(portal + `/manager/cmgtSaftyDangerCheckrecordDetail/` + id).then(res => {
      cb(res.data)
    })
  },

  // 通过id查询隐患详情
  getHiddenDangerDetails(id) {
    return req.get(portal + `/manager/CSaftyDangerAbarbeitung/hiddenDangerDetails?id=${id}`)
  },

  loadFileList(data, cb) {
    req.post(portal + '/file/v1/list', data).then(res => {
      cb(res.data)
    })
  },

  loadAllUnit(data, cb) {
    req.post(portal + '/manager/cmgtSaftyDangerUnit/query', data).then(res => {
      cb(res.data)
    })
  },
  downloadFile(data) {
    req.downloadGetCopy(portal + '/file/v1/downloadFile?fileId=' + data)
  },
  deleteFile(data, cb) {
    req.post(portal + '/file/v1/remove', data).then(res => {
      cb(res.data)
    })
  },
  closeSaftyDangerCheckrecord(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerCheckrecord/closeDanger`, data).then(res => {
      cb(res.data)
    })
  },
  dangerReport(id, cb) {
    req.post(portal + `/manager/CSaftyDangerAbarbeitung/eventBack?id=${id}`).then(res => {
      cb(res.data)
    })
  },
  getEventDetail(id, cb) {
    req.post(portal + `/manager/CSaftyDangerAbarbeitung/eventBack/eventInfo?id=${id}`).then(res => {
      cb(res.data)
    })
  }
}
