import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增家庭成员
  addDwdLkFamilyMember(data, cb) {
    req.post(portal + `/manager/dwdLkFamilyMember/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改家庭成员
  editDwdLkFamilyMember(data, cb) {
    req.put(portal + `/manager/dwdLkFamilyMember/`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询家庭成员
  loadDwdLkFamilyMember(data, cb) {
    req.post(portal + `/manager/dwdLkFamilyMember/pageQuery`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除家庭成员
  deleteDwdLkFamilyMember(data, cb) {
    req.remove(portal + `/manager/dwdLkFamilyMember/`, data).then(res => {
      cb(res.data)
    })
  },
}
