package com.artfess.workflow.bpmModel.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.persistence.manager.BpmWatermarkManager;
import com.artfess.bpm.persistence.manager.BpmWatermarkProcessManager;
import com.artfess.bpm.persistence.manager.BpmWatermarkTypeManager;
import com.artfess.bpm.persistence.model.BpmWatermark;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 
 * <pre> 
 * 描述：流程水印 控制器类
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-09-02 16:54:36
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value="/bpmModel/bpmWatermark/v1")
@Api(tags="bpmWatermarkController")
public class BpmWatermarkController extends BaseController<BpmWatermarkManager,BpmWatermark>{
	@Resource
	BpmWatermarkManager bpmWatermarkManager;
	@Resource
	BpmWatermarkTypeManager bpmWatermarkTypeManager;
	@Resource
	BpmWatermarkProcessManager bpmWatermarkProcessManager;

	/**
	 * 流程水印列表(分页条件查询)数据
	 * @param request
	 * @return
	 * @throws Exception 
	 * PageJson
	 * @exception 
	 */
	@PostMapping("/listJson")
	@ApiOperation(value="流程水印数据列表", httpMethod = "POST", notes = "获取流程水印列表")
	public PageList<BpmWatermark> list(@ApiParam(name="queryFilter",value="查询对象")@RequestBody QueryFilter queryFilter) throws Exception{
		return bpmWatermarkManager.query(queryFilter);
	}
	
	/**
	 * 流程水印明细页面
	 * @param id
	 * @return
	 * @throws Exception 
	 * ModelAndView
	 */
	@GetMapping(value="/getJson")
	@ApiOperation(value="流程水印数据详情",httpMethod = "GET",notes = "流程水印数据详情")
	public BpmWatermark get(@ApiParam(name="id",value="业务对象主键", required = true)@RequestParam String id) throws Exception{
		return bpmWatermarkManager.get(id);
	}
	
    /**
	 * 新增流程水印
	 * @param bpmWatermark
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="save")
	@ApiOperation(value = "新增,更新流程水印数据", httpMethod = "POST", notes = "新增,更新流程水印数据")
	public CommonResult<String> save(@ApiParam(name="bpmWatermark",value="流程水印业务对象", required = true)@RequestBody BpmWatermark bpmWatermark) throws Exception{
		String msg = "添加流程水印成功";
		if(StringUtil.isEmpty(bpmWatermark.getId())){
			bpmWatermarkManager.create(bpmWatermark);
		}else{
			bpmWatermarkManager.update(bpmWatermark);
			 msg = "更新流程水印成功";
		}
		return new CommonResult<String>(msg);
	}
	
	/**
	 * 批量删除流程水印记录
	 * @param ids
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="/remove")
	@ApiOperation(value = "批量删除流程水印记录", httpMethod = "DELETE", notes = "批量删除流程水印记录")
	public CommonResult<String> removes(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		bpmWatermarkManager.batchRemove(ids);
		return new CommonResult<String>(true, "批量删除成功");
	}

	@GetMapping(value="/getByInstId")
	@ApiOperation(value = "通过", httpMethod = "POST", notes = "批量添加")
	public BpmWatermark getByInstId(
			@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestParam(value="instId") String instId){
		return bpmWatermarkManager.getByInstId(instId);
	}
}
