package com.artfess.yhxt.task.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialcheck.vo.SiteTaskVo;
import com.artfess.yhxt.task.vo.TaskWaitHandleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.task.model.TaskWaitHandle;
import com.artfess.yhxt.task.manager.TaskWaitHandleManager;

/**
 * 主要是从各个业务过程中向里面插入待处理的任务数据，然后提供门户进行统一查询跳转并处理 前端控制器
 *
 * @author baseli
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-09-16
 */
@RestController
@RequestMapping("/bizTaskWaitHandle/v1/")
@Api(tags = "巡检待办任务管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class TaskWaitHandleController extends BaseController<TaskWaitHandleManager, TaskWaitHandle> {
    @RequestMapping(value = "/getJson", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "分页查询待办管理", httpMethod = "POST")
    public PageList<TaskWaitHandleVo> getJson(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<TaskWaitHandle> queryFilter) {
        queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
        PageList<TaskWaitHandleVo> pageList = baseService.queryTaskWaitHandle(queryFilter);
        return pageList;
    }


    @RequestMapping(value = "/otherSendPeople", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "另派人员接口", httpMethod = "POST")
    public CommonResult<String> otherSendPeople(@ApiParam(name = "siteTaskVo", value = "巡检") @RequestBody SiteTaskVo siteTaskVo) {
        baseService.otherSendPeople(siteTaskVo);
        return new CommonResult<>(true, "操作成功");
    }

}
