package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 工程质量管理质检单整改表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-16
 */
@ApiModel(value="BizProjectManageQualityChange对象", description="工程质量管理质检单整改表")
@TableName("biz_project_manage_quality_change")
public class BizProjectManageQualityChange extends BizModel<BizProjectManageQualityChange> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "质检单整改表id")
    @TableField("REFORM_ID_")
    private String reformId;

    @ApiModelProperty(value = "质检单表id")
    @TableField("TEST_ID_")
    private String testId;

    @ApiModelProperty(value = "整改序号")
    @TableField("REFORM_SEQ_")
    private Integer reformSeq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "整改时间")
    @TableField("REFORM_DATE_")
    private LocalDate reformDate;

    @ApiModelProperty(value = "整改结果（1-已整改、0-未整改)")
    @TableField("REFORM_FLAG_")
    private Integer reformFlag;

    @ApiModelProperty(value = "整改结果描述")
    @TableField("REFORM_DESCRIPTION_")
    private String reformDescription;

    @ApiModelProperty(value = "整改施工方人员")
    @TableField("REFORM_USE_ID_")
    private String reformUseId;

    @ApiModelProperty(value = "整改施工方")
    @TableField("REFORM_DEPART_")
    private String reformDepart;

    @ApiModelProperty(value = "复查时间")
    @TableField("CONFIRM_DATE_")
    private LocalDate confirmDate;

    @ApiModelProperty(value = "复查结果（0-待复查、1-通过、2-不通过)")
    @TableField("CONFIRM_RESULT_")
    private Integer confirmResult;

    @ApiModelProperty(value = "复查结果描述")
    @TableField("CONFIRM_DESCRIPTION_")
    private String confirmDescription;

    @ApiModelProperty(value = "复查人（质检单表的testUser）")
    @TableField("CONFIRM_USER_ID_")
    private String confirmUserId;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getReformId() {
        return reformId;
    }

    public void setReformId(String reformId) {
        this.reformId = reformId;
    }
    public String getTestId() {
        return testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }
    public Integer getReformSeq() {
        return reformSeq;
    }

    public void setReformSeq(Integer reformSeq) {
        this.reformSeq = reformSeq;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public LocalDate getReformDate() {
        return reformDate;
    }

    public void setReformDate(LocalDate reformDate) {
        this.reformDate = reformDate;
    }
    public Integer getReformFlag() {
        return reformFlag;
    }

    public void setReformFlag(Integer reformFlag) {
        this.reformFlag = reformFlag;
    }
    public String getReformDescription() {
        return reformDescription;
    }

    public void setReformDescription(String reformDescription) {
        this.reformDescription = reformDescription;
    }
    public String getReformUseId() {
        return reformUseId;
    }

    public void setReformUseId(String reformUseId) {
        this.reformUseId = reformUseId;
    }
    public String getReformDepart() {
        return reformDepart;
    }

    public void setReformDepart(String reformDepart) {
        this.reformDepart = reformDepart;
    }
    public LocalDate getConfirmDate() {
        return confirmDate;
    }

    public void setConfirmDate(LocalDate confirmDate) {
        this.confirmDate = confirmDate;
    }
    public Integer getConfirmResult() {
        return confirmResult;
    }

    public void setConfirmResult(Integer confirmResult) {
        this.confirmResult = confirmResult;
    }
    public String getConfirmDescription() {
        return confirmDescription;
    }

    public void setConfirmDescription(String confirmDescription) {
        this.confirmDescription = confirmDescription;
    }
    public String getConfirmUserId() {
        return confirmUserId;
    }

    public void setConfirmUserId(String confirmUserId) {
        this.confirmUserId = confirmUserId;
    }
    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizProjectManageQualityChange{" +
            "id=" + id +
            ", reformId=" + reformId +
            ", testId=" + testId +
            ", reformSeq=" + reformSeq +
            ", remarks=" + remarks +
            ", reformDate=" + reformDate +
            ", reformFlag=" + reformFlag +
            ", reformDescription=" + reformDescription +
            ", reformUseId=" + reformUseId +
            ", reformDepart=" + reformDepart +
            ", confirmDate=" + confirmDate +
            ", confirmResult=" + confirmResult +
            ", confirmDescription=" + confirmDescription +
            ", confirmUserId=" + confirmUserId +
            ", validFlag=" + validFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
