package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.yhxt.specialcheck.manager.BizMqiCheckDetailManager;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.manager.BizEngineeringProjectManager;
import com.artfess.yhxt.specialproject.model.*;
import com.artfess.yhxt.specialproject.model.BizProjectBeginApplyFor;
import com.artfess.yhxt.specialproject.dao.BizProjectBeginApplyForDao;
import com.artfess.yhxt.specialproject.manager.BizProjectBeginApplyForManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.model.BizProjectBeginApplyFor;
import com.artfess.yhxt.specialproject.vo.BizProjectBeginApplyForEngineeringVo;
import com.artfess.yhxt.specialproject.vo.BizProjectBeginApplyForVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import net.hasor.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 项目开工申请表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@Service
public class BizProjectBeginApplyForManagerImpl extends BaseManagerImpl<BizProjectBeginApplyForDao, BizProjectBeginApplyFor> implements BizProjectBeginApplyForManager {

   @Resource
   private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;
   @Resource
   private BizEngineeringProjectManager bizEngineeringProjectManager;

    @Override
    public PageList<BizProjectBeginApplyFor> queryBizProjectBeginApplyFor(QueryFilter<BizProjectBeginApplyFor> queryFilter) {
        IPage<BizProjectBeginApplyFor> result = baseMapper.queryBizProjectBeginApplyFor(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter,currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizProjectBeginApplyFor getBizProjectBeginApplyForById(String id) {
        BizProjectBeginApplyFor bizProjectBeginApplyFor = baseMapper.selectById(id);
        return bizProjectBeginApplyFor;
    }

    @Override
    public void saveProjectBeginApplyForStateVo(BizProjectBeginApplyForVo vo) {
        LocalDateTime nowTime = LocalDateTime.now();
        IUser user= ContextUtil.getCurrentUser();
        if (StringUtils.isEmpty(vo.getId())){
            UpdateWrapper<BizProjectBeginApplyFor> updateWrapper = new UpdateWrapper<>();
            updateWrapper.set("CONFIRM_TIME_",nowTime);
            updateWrapper.set("CONFIRM_STATUS_ ",vo.getConfirmStatus());
            updateWrapper.set("STARTUP_DESCRIPTION_",vo.getConfirmDescription());
            updateWrapper.set("CONFIRM_USER_ID_",user.getFullname());
            baseMapper.update(null,updateWrapper);
        }
    }

    @Override
    public void saveVo(BizProjectBeginApplyForEngineeringVo bizProjectBeginApplyForEngineeringVo) {
        //开工申请信息
        BizProjectBeginApplyFor bizProjectBeginApplyFor = bizProjectBeginApplyForEngineeringVo.getBizProjectBeginApplyFor();
        this.create(bizProjectBeginApplyFor);
        //附件
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizProjectBeginApplyForEngineeringVo.getBizEngineeringAccessoriesList();
        String sourceId = bizProjectBeginApplyFor.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);

        //修改项目状态

        if(null != bizProjectBeginApplyFor.getConfirmStatus() && bizProjectBeginApplyFor.getConfirmStatus() == 1){
            UpdateWrapper<BizEngineeringProject> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("ID_",bizProjectBeginApplyFor.getProjectId());
            updateWrapper.set("STARTUP_FLAG_","1");
            bizEngineeringProjectManager.update(null,updateWrapper);
        }
    }

    @Override
    public void updateVo(BizProjectBeginApplyForEngineeringVo bizProjectBeginApplyForEngineeringVo) {
        //开工申请信息
        BizProjectBeginApplyFor bizProjectBeginApplyFor = bizProjectBeginApplyForEngineeringVo.getBizProjectBeginApplyFor();
        this.update(bizProjectBeginApplyFor);
        String sourceId = bizProjectBeginApplyFor.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizProjectBeginApplyForEngineeringVo.getBizEngineeringAccessoriesList();
        bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public BizProjectBeginApplyForEngineeringVo getVo(String id) {
        BizProjectBeginApplyForEngineeringVo bizProjectBeginApplyForEngineeringVo= new BizProjectBeginApplyForEngineeringVo();
        BizProjectBeginApplyFor bizProjectBeginApplyFor = this.getById(id);
        List<BizEngineeringAccessories> engineeringAccessories = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        bizProjectBeginApplyForEngineeringVo.setBizProjectBeginApplyFor(bizProjectBeginApplyFor);
        bizProjectBeginApplyForEngineeringVo.setBizEngineeringAccessoriesList(engineeringAccessories);
        return bizProjectBeginApplyForEngineeringVo;
    }

}
