package com.artfess.yhxt.check.detail.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 边坡定期检查明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-17
 */
@ApiModel(value="SideRegularCheckDetail对象", description="边坡定期检查明细表")
@TableName("biz_side_regular_check_detail")
public class SideRegularCheckDetail extends BaseModel<SideRegularCheckDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "边坡定期检查明")
    @TableField("SIDE_SLOPE_REGULAR_CHECK_ID_")
    private String sideSlopeRegularCheckId;

    @Excel(name = "结构名称", orderNum = "0")
    @ApiModelProperty(value = "结构名称")
    @TableField("UNIT_NAME_")
    private String unitName;

    @Excel(name = "评分(0-5)", orderNum = "1")
    @ApiModelProperty(value = "评分（1-5）")
    @TableField("SCORE_")
    private Integer score;

    @Excel(name = "特别检查", orderNum = "2")
    @ApiModelProperty(value = "特别检查")
    @TableField("SPECIAL_CHECK_")
    private String specialCheck;

    @Excel(name = "维修范围", orderNum = "3")
    @ApiModelProperty(value = "维修范围")
    @TableField("REPAIR_SCOPE_")
    private String repairScope;

    @Excel(name = "维修方式", orderNum = "4")
    @ApiModelProperty(value = "维修方式")
    @TableField("REPAIR_WAY_")
    private String repairWay;

    @Excel(name = "维修时间", orderNum = "5", format = "yyyy-MM-dd")
    @ApiModelProperty(value = "维修时间")
    @TableField("REPAIR_DATE_")
    private LocalDate repairDate;

    @Excel(name = "维修费用", orderNum = "6")
    @ApiModelProperty(value = "维修费用")
    @TableField("COST_")
    private String cost;

    @Excel(name = "缺损位置", orderNum = "7")
    @ApiModelProperty(value = "缺损位置")
    @TableField("BROKEN_PLACE_")
    private String brokenPlace;

    @Excel(name = "破损情况", orderNum = "8")
    @ApiModelProperty(value = "破损情况")
    @TableField("BROKEN_STATE_")
    private String brokenState;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getSideSlopeRegularCheckId() {
        return sideSlopeRegularCheckId;
    }

    public void setSideSlopeRegularCheckId(String sideSlopeRegularCheckId) {
        this.sideSlopeRegularCheckId = sideSlopeRegularCheckId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }
    public String getSpecialCheck() {
        return specialCheck;
    }

    public void setSpecialCheck(String specialCheck) {
        this.specialCheck = specialCheck;
    }
    public String getRepairScope() {
        return repairScope;
    }

    public void setRepairScope(String repairScope) {
        this.repairScope = repairScope;
    }
    public String getRepairWay() {
        return repairWay;
    }

    public void setRepairWay(String repairWay) {
        this.repairWay = repairWay;
    }
    public LocalDate getRepairDate() {
        return repairDate;
    }

    public void setRepairDate(LocalDate repairDate) {
        this.repairDate = repairDate;
    }
    public String getCost() {
        return cost;
    }

    public void setCost(String cost) {
        this.cost = cost;
    }
    public String getBrokenPlace() {
        return brokenPlace;
    }

    public void setBrokenPlace(String brokenPlace) {
        this.brokenPlace = brokenPlace;
    }
    public String getBrokenState() {
        return brokenState;
    }

    public void setBrokenState(String brokenState) {
        this.brokenState = brokenState;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "SideRegularCheckDetail{" +
            "id=" + id +
            ", sideSlopeRegularCheckId=" + sideSlopeRegularCheckId +
            ", unitName=" + unitName +
            ", score=" + score +
            ", specialCheck=" + specialCheck +
            ", repairScope=" + repairScope +
            ", repairWay=" + repairWay +
            ", repairDate=" + repairDate +
            ", cost=" + cost +
            ", brokenPlace=" + brokenPlace +
            ", brokenState=" + brokenState +
        "}";
    }
}
