package com.artfess.yhxt.budget.controller;


import com.artfess.yhxt.budget.manager.YearBudgetDetailedManager;
import com.artfess.yhxt.budget.model.YearBudgetDetailed;
import com.artfess.yhxt.budget.vo.YearBudgetDetailedVo;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;

import java.util.Arrays;
import java.util.List;

/**
 * 年度总预算明细表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-02
 */
@RestController
@RequestMapping("/yearBudgetDetailed/v1/")
@Api(tags = "年度总预算明细")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class YearBudgetDetailedController extends BaseController<YearBudgetDetailedManager, YearBudgetDetailed> {

    @RequestMapping(value = "saveYearBudgetDetailed", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改年度总预算明细", httpMethod = "POST")
    public CommonResult<String> saveYearBudgetDetailed(@ApiParam(name = "yearBudget", value = "年度年度总预算明细") @RequestBody YearBudgetDetailed yearBudgetDetailed) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(yearBudgetDetailed.getId())) {
            yearBudgetDetailed.setIsDele("0");
            baseService.create(yearBudgetDetailed);
            baseService.saveYearBudget(yearBudgetDetailed.getAscriptionYear(),yearBudgetDetailed.getYearBudgetId());
        } else {
            baseService.update(yearBudgetDetailed);
            baseService.saveYearBudget(yearBudgetDetailed.getAscriptionYear(),yearBudgetDetailed.getYearBudgetId());
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value="getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询年度总预算明细",httpMethod = "POST")
    public PageList<YearBudgetDetailedVo> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<YearBudgetDetailed> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        PageList<YearBudgetDetailedVo> pageList = baseService.queryVo(queryFilter);
        return  pageList;
    }


    @RequestMapping(value="get/{id}",method = RequestMethod.GET, produces={"application/json; charset=utf-8" })
    @ApiOperation(value="根据ID查询年度总预算明细",httpMethod = "GET",notes = "根据ID查询年度总预算明细")
    public YearBudgetDetailed get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getYearBudgetDetailedById(id);
    }

    @RequestMapping(value = "updateYearBudgetDetailed", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除年度总预算明细", httpMethod = "DELETE", notes = "逻辑删除年度总预算明细")
    public CommonResult<String> updateYearBudgetDetailed(@ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
                                                 @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<YearBudgetDetailed> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }
}
