package com.artfess.yhxt.basedata.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 涵洞信息表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-07-28
 */
@ApiModel(description="涵洞信息表")
@TableName("biz_culvert_information")
@Data
@JsonInclude(JsonInclude.Include.ALWAYS)
public class BizCulvertInformation extends BizModel<BizCulvertInformation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_")
    private String id;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "所属公司多个ID")
    @TableField("COMPANY_IDS_")
    private String companyIds;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "编号")
    @TableField("NUMBER_")
    private String number;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "管养单位ID")
    @TableField("OFFICE_ID_")
    private String officeId;

    @ApiModelProperty(value = "管养单位名称")
    @TableField("OFFICE_NAME_")
    private String officeName;

    @ApiModelProperty(value = "名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "类型1:盖板涵 2:管涵 3:箱涵 4:拱涵 5:倒虹吸")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "中心桩号")
    @TableField("CENT_PEG_")
    private String centPeg;

    @ApiModelProperty(value = "方向 1:上行方向 2:下行方向 3:上下双向 4:匝道")
    @TableField("DIRECTION_")
    private String direction;

    @ApiModelProperty(value = "匝道桩号")
    @TableField("RAMP_PEG_")
    private String rampPeg;

    @ApiModelProperty(value = "高度")
    @TableField("HEIGHT_")
    private Float height;

    @ApiModelProperty(value = "长度")
    @TableField("LENGTH_")
    private Float length;

    @ApiModelProperty(value = "跨径")
    @TableField("SPAN_")
    private Float span;

    @ApiModelProperty(value = "孔数")
    @TableField("HOLE_COUNT_")
    private Integer holeCount;

    @ApiModelProperty(value = "洞身材料")
    @TableField("BODY_MATERIAL_")
    private String bodyMaterial;

    @ApiModelProperty(value = "洞顶材料")
    @TableField("TOP_MATERIAL_")
    private String topMaterial;

    @ApiModelProperty(value = "进洞口材料 1:预应力混凝土 2:整齐块石或条石 3:钢筋混凝土 4:其他混凝土 5:型钢（普通钢） 6:钢波纹管 7:球墨铸铁 ")
    @TableField("ENTRANCE_MATERIAL_")
    private String entranceMaterial;

    @ApiModelProperty(value = "进洞口形式 1:一字墙 2:八字墙 3:扇形 4:跌水井 5：端墙 6：直翼墙 7:锥坡 8:竖井 9:排水沟 10:急流槽 11:挡墙" +
            "12:挡墙+跌水井 13 其他")
    @TableField("ENTRANCE_FORM_")
    private String entranceForm;

    @ApiModelProperty(value = "出洞口材料 1:预应力混凝土 2:整齐块石或条石 3:钢筋混凝土 4:其他混凝土 5:型钢（普通钢） 6:钢波纹管 7:球墨铸铁 ")
    @TableField("EXIT_MATERIAL_")
    private String exitMaterial;

    @ApiModelProperty(value = "出洞口形式 1:一字墙 2:八字墙 3:扇形 4:跌水井 5：端墙 6：直翼墙 7:锥坡 8:竖井 9:排水沟 10:急流槽 11:挡墙" +
            "12:挡墙+跌水井 13 其他")
    @TableField("EXIT_FORM_")
    private String exitForm;

    @ApiModelProperty(value = "完成日期")
    @TableField("FINISH_DAY_")
    private String finishDay;

    @ApiModelProperty(value = "用途 1:排水 2:过人3:过车4:管线5:过人兼排水6:过人兼管线" +
            "7:排水兼管线8:过人过车兼排水9:综合10:其他")
    @TableField("USES_")
    private String uses;

    @ApiModelProperty(value = "X")
    @TableField("X_")
    private String x;

    @ApiModelProperty(value = "Y")
    @TableField("Y_")
    private String y;

    @ApiModelProperty(value = "类型值")
    @TableField("TYPE_VALUE_")
    private String typeValue;

    @ApiModelProperty(value = "中心桩号KM")
    @TableField("CENT_PEG_K_")
    private String centPegK;

    @ApiModelProperty(value = "匝道桩号")
    @TableField("RAMP_PEG_K_")
    private String rampPegK;

    @ApiModelProperty(value = "出口形式值")
    @TableField("EXIT_FORM_VALUE_")
    private String exitFormValue;

    @ApiModelProperty(value = "用途值")
    @TableField("USES_VALUE_")
    private String usesValue;

    @ApiModelProperty(value = "方向值")
    @TableField("DIRECTION_VALUE_")
    private String directionValue;

    @ApiModelProperty(value = "中心桩号匝道桩号")
    @TableField("CENT_PEG_AND_RAMP_PEG_K_")
    private String centPegAndRampPegK;

    @ApiModelProperty(value = "洞身材料值")
    @TableField("BODY_MATERIAL_VALUE_")
    private String bodyMaterialValue;

    @ApiModelProperty(value = "洞顶材料值")
    @TableField("TOP_MATERIAL_VALUE_")
    private String topMaterialValue;

    @ApiModelProperty(value = "入口材料值")
    @TableField("ENTRANCE_MATERIAL_VALUE_")
    private String entranceMaterialValue;

    @ApiModelProperty(value = "入口形式值")
    @TableField("ENTRANCE_FORM_VALUE_")
    private String entranceFormValue;

    @ApiModelProperty(value = "出口材料值")
    @TableField("EXIT_MATERIAL_VALUE_")
    private String exitMaterialValue;

    @ApiModelProperty(value = "经度")
    @TableField("LNG")
    private Double lng;
    @ApiModelProperty(value = "维度")
    @TableField("LAT")
    private Double lat;

    @ApiModelProperty(value = "交叉角度")
    @TableField("CROSS_ANGLE_")
    private String crossAngle;

    @ApiModelProperty(value = "所属行政区")
    @TableField("ADMINISTRATIVE_REGION_")
    private String administrativeRegion;

    @ApiModelProperty(value = "起点桩号")
    @TableField("START_PEG_")
    private String startPeg;

    @ApiModelProperty(value = "止点桩号")
    @TableField("END_PEG_")
    private String endPeg;

    //正面图:frontView  侧面图:lateralView 二维平面图:twoDimensionalPlan
    @ApiModelProperty(value = "正面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesFrontView;
    @ApiModelProperty(value = "侧面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesLateralView;
    @ApiModelProperty(value = "二维平面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesTwoDimensionalView;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }


}
