package com.artfess.yhxt.basedata.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 附件表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-03
 */
@ApiModel(value="BizAccessory对象", description="附件表")
@TableName("biz_accessory")
@Data
public class Accessory extends BizModel<Accessory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "附件类型")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "对应资源Id")
    @TableField("SOURCE_ID_")
    private String sourceId;

    @ApiModelProperty(value = "附件名")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "路径")
    @TableField("URL_")
    private String url;

    @ApiModelProperty(value = "分组编码，养护工单中用于标识施工前中后照片，施工前：constructionPre,施工中：constructionUnd,施工后：constructionSuf" +
            "基础数据:正面图:frontView  侧面图:lateralView 二维平面图:twoDimensionalView")
    @TableField("GROUP_")
    private String group;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "后缀")
    @TableField("SUFFIX_")
    private String suffix;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "所属公司多个ID")
    @TableField("COMPANY_IDS_")
    private String companyIds;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "图片minio中的URL")
    @TableField(exist = false)
    private String minioUrl;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAccessory{" +
            "id=" + id +
            ", type=" + type +
            ", sourceId=" + sourceId +
            ", name=" + name +
            ", url=" + url +
            ", remarks=" + remarks +
            ", suffix=" + suffix +
            ", companyId=" + companyId +
            ", companyIds=" + companyIds +
            ", companyName=" + companyName +
        "}";
    }
}
