package com.artfess.yhxt.thirdparty.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 第三方传输预警事件
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-16
 */
@ApiModel(value="BizTpWarningEvents对象", description="第三方传输预警事件")
@Data
public class BizTpWarningEvents extends BaseModel<BizTpWarningEvents> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "事件描述")
    @TableField("EVENTS_DESCRIBE_")
    private String eventsDescribe;


    @ApiModelProperty(value = "经度")
    @TableField("LAT_")
    private String lat;

    @ApiModelProperty(value = "纬度")
    @TableField("LNG_")
    private String lng;

    @ApiModelProperty(value = "关联桥梁编码")
    @TableField("TP_BRIDGE_CODE_")
    private String tpBridgeCode;

    @ApiModelProperty(value = "关联桥梁名称")
    @TableField("TP_BRIDGE_NAME_")
    private String tpBridgeName;

    @ApiModelProperty(value = "关联桥梁id")
    @TableField("TP_BRIDGE_ID_")
    private String tpBridgeId;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "所属公司多个ID")
    @TableField("COMPANY_IDS_")
    private String companyIds;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;


    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段名称")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "第三方设备id")
    @TableField("DEVICE_ID_")
    private String deviceId;


    @ApiModelProperty(value = "第三方桥梁id")
    @TableField("TR_BRIDGE_ID_")
    private String trBridgeId;

    @ApiModelProperty(value = "预警类型  1蓝色预警 2黄色预警 3红色预警")
    @TableField("WARN_TYPE_")
    private Integer warnType;

    @ApiModelProperty(value = "事件处置状态  0未处理  1已处理")
    @TableField("EVENTS_STATE_")
    private Integer eventsState;

    @ApiModelProperty(value = "事件发生时间")
    @TableField("EVENTS_DATE_")
    private LocalDateTime eventsDate;

    @ApiModelProperty(value = "事件处理时间")
    @TableField("DEAL_DATE_")
    private LocalDateTime dealDate;


    @ApiModelProperty(value = "预警阀值")
    @TableField("THRESHOLD_LIMIT_")
    private Integer thresholdLimit;

    @ApiModelProperty(value = "当前预警值")
    @TableField("THRESHOLD_NOW_")
    private Integer thresholdNow;



    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建人单位ID")
    @TableField("CREATE_COMPANY_ID_")
    private String createCompanyId;

    @ApiModelProperty(value = "创建人单位名称")
    @TableField("CREATE_COMPANY_NAME_")
    private String createCompanyName;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人单位名称")
    @TableField("UPDATE_COMPANY_NAME_")
    private String updateCompanyName;

    @ApiModelProperty(value = "更新人单位ID")
    @TableField("UPDATE_COMPANY_ID_")
    private String updateCompanyId;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;


}
