package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目开工申请表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@ApiModel(value="BizProjectBeginApplyFor对象", description="项目开工申请表")
@TableName("biz_project_begin_apply_for")
@Data
public class BizProjectBeginApplyFor extends BizModel<BizProjectBeginApplyFor> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "开工项目表id")
    @TableField("STARTUP_ID_")
    private String startupId;

    @ApiModelProperty(value = "工程表id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "工程属性(1:维修工程 2:分项项目)")
    @TableField("PROJECT_NATURE_")
    private String projectNature;

    @ApiModelProperty(value = "工程类型(1 一般工程 2 专项工程)")
    @TableField("PROJECT_CATEGORY_")
    private String projectCategory;

    @ApiModelProperty(value = "开工时间")
    @TableField("STARTUP_TIME_")
    private LocalDate startupTime;

    @ApiModelProperty(value = "完工时间（预估）")
    @TableField("EXPECTED_COMPLETE_TIME_")
    private LocalDate expectedCompleteTime;

    @ApiModelProperty(value = "完工时间（实际）")
    @TableField("ACTUAL_COMPLETE_TIME_")
    private LocalDate actualCompleteTime;

    @ApiModelProperty(value = "开工申请人id")
    @TableField("APPLY_USER_ID_")
    private String applyUserId;

    @ApiModelProperty(value = "开工申请人名")
    @TableField("APPLY_USER_NAME_")
    private String applyUserName;

    @ApiModelProperty(value = "监理方审批人")
    @TableField("CONFIRM_USER_ID_")
    private String confirmUserId;

    @ApiModelProperty(value = "监理方审批状态（0-待审批、1-通过、2-不通过）")
    @TableField("CONFIRM_STATUS_")
    private Integer confirmStatus;

    @ApiModelProperty(value = "监理方审批时间")
    @TableField("CONFIRM_TIME_")
    private LocalDateTime confirmTime;

    @ApiModelProperty(value = "监理方审批意见")
    @TableField("CONFIRM_DESCRIPTION_")
    private String confirmDescription;

    @ApiModelProperty(value = "开工申请描述")
    @TableField("STARTUP_DESCRIPTION_")
    private String startupDescription;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStartupId() {
        return startupId;
    }

    public void setStartupId(String startupId) {
        this.startupId = startupId;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectNature() {
        return projectNature;
    }

    public void setProjectNature(String projectNature) {
        this.projectNature = projectNature;
    }

    public String getProjectCategory() {
        return projectCategory;
    }

    public void setProjectCategory(String projectCategory) {
        this.projectCategory = projectCategory;
    }

    public LocalDate getStartupTime() {
        return startupTime;
    }

    public void setStartupTime(LocalDate startupTime) {
        this.startupTime = startupTime;
    }

    public LocalDate getExpectedCompleteTime() {
        return expectedCompleteTime;
    }

    public void setExpectedCompleteTime(LocalDate expectedCompleteTime) {
        this.expectedCompleteTime = expectedCompleteTime;
    }

    public LocalDate getActualCompleteTime() {
        return actualCompleteTime;
    }

    public void setActualCompleteTime(LocalDate actualCompleteTime) {
        this.actualCompleteTime = actualCompleteTime;
    }

    public String getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(String applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public String getConfirmUserId() {
        return confirmUserId;
    }

    public void setConfirmUserId(String confirmUserId) {
        this.confirmUserId = confirmUserId;
    }

    public Integer getConfirmStatus() {
        return confirmStatus;
    }

    public void setConfirmStatus(Integer confirmStatus) {
        this.confirmStatus = confirmStatus;
    }

    public LocalDateTime getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(LocalDateTime confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getConfirmDescription() {
        return confirmDescription;
    }

    public void setConfirmDescription(String confirmDescription) {
        this.confirmDescription = confirmDescription;
    }

    public String getStartupDescription() {
        return startupDescription;
    }

    public void setStartupDescription(String startupDescription) {
        this.startupDescription = startupDescription;
    }

    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizProjectBeginApplyFor{" +
            "id=" + id +
            ", startupId=" + startupId +
            ", projectId=" + projectId +
            ", projectName=" + projectName +
            ", projectNature=" + projectNature +
            ", projectCategory=" + projectCategory +
            ", startupTime=" + startupTime +
            ", expectedCompleteTime=" + expectedCompleteTime +
            ", actualCompleteTime=" + actualCompleteTime +
            ", applyUserId=" + applyUserId +
            ", applyUserName=" + applyUserName +
            ", confirmUserId=" + confirmUserId +
            ", confirmStatus=" + confirmStatus +
            ", confirmTime=" + confirmTime +
            ", confirmDescription=" + confirmDescription +
            ", startupDescription=" + startupDescription +
            ", validFlag=" + validFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
