package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.BizProjectManageQuality;
import com.artfess.yhxt.specialproject.model.BizProjectManageQualityChange;
import com.artfess.yhxt.specialproject.dao.BizProjectManageQualityChangeDao;
import com.artfess.yhxt.specialproject.manager.BizProjectManageQualityChangeManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.vo.BizProjectManageQualityChangeVo;
import com.artfess.yhxt.specialproject.vo.ProjectManageQualityChangeVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import net.hasor.utils.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 工程质量管理质检单整改表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-16
 */
@Service
public class BizProjectManageQualityChangeManagerImpl extends BaseManagerImpl<BizProjectManageQualityChangeDao, BizProjectManageQualityChange> implements BizProjectManageQualityChangeManager {
    @Resource
    private BizEngineeringAccessoriesManager  bizEngineeringAccessoriesManager;

    @Override
    public PageList<BizProjectManageQualityChange> queryBizProjectManageQualityChange(QueryFilter<BizProjectManageQualityChange> queryFilter) {
        IPage<BizProjectManageQualityChange> result =  baseMapper.queryBizProjectManageQualityChange(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizProjectManageQualityChange getBizProjectManageQualityChangeById(String id) {
        BizProjectManageQualityChange bizProjectManageQualityChange = baseMapper.selectById(id);
        return bizProjectManageQualityChange;
    }

    @Override
    public PageList<BizProjectManageQualityChangeVo> queryProjectManageQuality(QueryFilter<BizProjectManageQualityChange> queryFilter) {
        IPage<BizProjectManageQualityChangeVo> result =  baseMapper.queryBizProjectManageQuality(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public void saveVo(ProjectManageQualityChangeVo projectManageQualityChangeVo) {
        BizProjectManageQualityChange bizProjectManageQualityChange = projectManageQualityChangeVo.getBizProjectManageQualityChange();
        bizProjectManageQualityChange.setReformFlag(0);
        bizProjectManageQualityChange.setConfirmResult(0);
        bizProjectManageQualityChange.setIsDele("0");
        this.create(bizProjectManageQualityChange);
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = projectManageQualityChangeVo.getBizEngineeringAccessoriesList();
        String sourceId = bizProjectManageQualityChange.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(ProjectManageQualityChangeVo projectManageQualityChangeVo) {
        //工程质量管理质检单整改表
        BizProjectManageQualityChange bizProjectManageQualityChange = projectManageQualityChangeVo.getBizProjectManageQualityChange();
        this.update(bizProjectManageQualityChange);
        String sourceId = bizProjectManageQualityChange.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = projectManageQualityChangeVo.getBizEngineeringAccessoriesList();
        bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public ProjectManageQualityChangeVo getVo(String id) {
        ProjectManageQualityChangeVo projectManageQualityChangeVo = new ProjectManageQualityChangeVo();
        BizProjectManageQualityChange bizProjectManageQualityChange = this.getById(id);
        projectManageQualityChangeVo.setBizProjectManageQualityChange(bizProjectManageQualityChange);
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        projectManageQualityChangeVo.setBizEngineeringAccessoriesList(bizEngineeringAccessoriesList);
        return projectManageQualityChangeVo;
    }


}
