package com.artfess.yhxt.specialproject.manager;

import com.artfess.yhxt.specialproject.model.MeasurementPayment;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.specialproject.params.ConstructionParamVo;
import com.artfess.yhxt.specialproject.vo.BizProjectWeeklyMonthlyReportVo;
import com.artfess.yhxt.specialproject.vo.MeasurementPaymentVo;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;

/**
 * 专项工程-计量支付 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xmz
 * @since 2022-06-29
 */
public interface MeasurementPaymentManager extends BaseManager<MeasurementPayment> {

    /**
     * 保存计量支付
     * @param vo
     */
    void saveVo(MeasurementPaymentVo vo);

    /**
     * 修改计量支付
     * @param vo
     */
    void updateVo(MeasurementPaymentVo vo);

    /**
     * 根据ids删除计量支付
     * @param ids
     * @return
     */
    boolean removeVo(String ids);

    /**
     *
     * @param param
     * @return
     */
    HSSFWorkbook exportConstruction(ConstructionParamVo param, HttpServletResponse response) throws Exception;

    HashMap onlinePreviewConstruction(ConstructionParamVo param, HttpServletResponse response) throws Exception;

    HSSFWorkbook exportCollect(ConstructionParamVo param, HttpServletResponse response);

    HashMap onlinePreviewCollect(ConstructionParamVo param, HttpServletResponse response) throws Exception;

    MeasurementPaymentVo getVoById(String id);
}
