package com.artfess.yhxt.specialcheck.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * MQI检查数据表明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-13
 */
@ApiModel(value="BizMqiCheckDetail对象", description="MQI检查数据表明细表")
@Data
public class BizMqiCheckDetail extends BizModel<BizMqiCheckDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "MQI数据表ID")
    @TableField("MQI_DATA_ID_")
    private String mqiDataId;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "年份")
    @TableField("YEAR_")
    private Integer year;

    @ApiModelProperty(value = "年份值")
    @TableField("YEAR_VALUE_")
    private String yearValue;

    @ApiModelProperty(value = "检查日期")
    @TableField("CHECK_DATE_")
    private LocalDate checkDate;

    @ApiModelProperty(value = "车道")
    @TableField("LANE_")
    private String lane;

    @ApiModelProperty(value = "车道中文值")
    @TableField("LANE_VALUE_")
    private String laneValue;

    @ApiModelProperty(value = "方向")
    @TableField("DIRECTION_")
    private String direction;

    @ApiModelProperty(value = "方向中文值")
    @TableField("DIRECTION_VALUE_")
    private String directionValue;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "路段ID(关联路段表ID)，弹窗选择")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段名称")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "路线ID，选择路段时带入")
    @TableField("ROUTE_ID_")
    private String routeId;

    @ApiModelProperty(value = "路线名称，选择路段时带入")
    @TableField("ROUTE_NAME_")
    private String routeName;

    @ApiModelProperty(value = "起点桩号")
    @TableField("START_PEG_")
    private String startPeg;

    @ApiModelProperty(value = "终点桩号")
    @TableField("END_PEG_")
    private String endPeg;

    @ApiModelProperty(value = "附件地址")
    @TableField("URL_")
    private String url;

    @ApiModelProperty(value = "MQI")
    @TableField("MQI_AVG_")
    private Float mqiAvg;

    @ApiModelProperty(value = "路面PQI")
    @TableField("PQI_AVG_")
    private Float pqiAvg;

    @ApiModelProperty(value = "路面损坏PCI")
    @TableField("PCI_AVG_")
    private Float pciAvg;

    @ApiModelProperty(value = "行驶质量RQI")
    @TableField("RQI_AVG_")
    private Float rqiAvg;

    @ApiModelProperty(value = "车辙深度RDI")
    @TableField("RDI_AVG_")
    private Float rdiAvg;

    @ApiModelProperty(value = "跳车PBI")
    @TableField("PBI_AVG_")
    private Float pbiAvg;

    @ApiModelProperty(value = "抗滑性能SRI")
    @TableField("SRI_AVG_")
    private Float sriAvg;

    @ApiModelProperty(value = "路基SCI")
    @TableField("SCI_AVG_")
    private Float sciAvg;

    @ApiModelProperty(value = "桥隧构造物BCI")
    @TableField("BCI_AVG_")
    private Float bciAvg;

    @ApiModelProperty(value = "沿线设施TCI")
    @TableField("TCI_AVG_")
    private Float tciAvg;

    @ApiModelProperty(value = "磨耗PWI")
    @TableField("PWI_AVG_")
    private Float pwiAvg;

    @ApiModelProperty(value = "结构强度PSSI")
    @TableField("PSSI_AVG_")
    private Float pssiAvg;

    @ApiModelProperty(value = "评定等级，使用数据字典")
    @TableField("RATING_")
    private Integer rating;

    @ApiModelProperty(value = "评定等级中文值")
    @TableField("RATING_VALUE_")
    private String ratingValue;

    @ApiModelProperty(value = "长度(m)")
    @TableField("LENGTH_")
    private String length;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizMqiCheckDetail{" +
            "id=" + id +
            ", mqiDataId=" + mqiDataId +
            ", remarks=" + remarks +
            ", year=" + year +
            ", yearValue=" + yearValue +
            ", checkDate=" + checkDate +
            ", lane=" + lane +
            ", laneValue=" + laneValue +
            ", direction=" + direction +
            ", directionValue=" + directionValue +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
            ", roadSegmentId=" + roadSegmentId +
            ", roadSegmentName=" + roadSegmentName +
            ", routeId=" + routeId +
            ", routeName=" + routeName +
            ", startPeg=" + startPeg +
            ", endPeg=" + endPeg +
            ", url=" + url +
            ", mqiAvg=" + mqiAvg +
            ", pqiAvg=" + pqiAvg +
            ", pciAvg=" + pciAvg +
            ", rqiAvg=" + rqiAvg +
            ", rdiAvg=" + rdiAvg +
            ", pbiAvg=" + pbiAvg +
            ", sriAvg=" + sriAvg +
            ", sciAvg=" + sciAvg +
            ", bciAvg=" + bciAvg +
            ", tciAvg=" + tciAvg +
            ", pwiAvg=" + pwiAvg +
            ", pssiAvg=" + pssiAvg +
            ", rating=" + rating +
            ", length=" + length +
            ", ratingValue=" + ratingValue +
        "}";
    }
}
