package com.artfess.yhxt.specialcheck.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.basedata.model.BizEngineeringDrawing;
import com.artfess.yhxt.basedata.vo.BizEngineeringDrawingVo;
import com.artfess.yhxt.specialcheck.vo.BizBridgeSpecialCheckVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialcheck.model.BizBridgeSpecialCheck;
import com.artfess.yhxt.specialcheck.manager.BizBridgeSpecialCheckManager;

import java.util.Arrays;
import java.util.List;

/**
 * 桥梁专项检查表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@RestController
@RequestMapping("/bizBridgeSpecialCheck/v1/")
@Api(tags = "桥梁专项检查接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizBridgeSpecialCheckController extends BaseController<BizBridgeSpecialCheckManager, BizBridgeSpecialCheck> {
    @RequestMapping(value = "/saveBridgeSpecialCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改桥梁专项检查信息", httpMethod = "POST")
    public CommonResult<BizBridgeSpecialCheck> saveTunnel(@ApiParam(name = "bizBridgeSpecialCheck", value = "桥梁专项检查对象") @RequestBody BizBridgeSpecialCheck bizBridgeSpecialCheck) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizBridgeSpecialCheck.getId())) {
            bizBridgeSpecialCheck.setIsDele("0");
            baseService.create(bizBridgeSpecialCheck);
        } else {
            baseService.update(bizBridgeSpecialCheck);
            msg = "修改成功";
        }
        return new CommonResult<BizBridgeSpecialCheck>(true,msg,bizBridgeSpecialCheck);
    }

    @RequestMapping(value = "/saveVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改桥梁专项检查、附件信息", httpMethod = "POST")
    public CommonResult<BizBridgeSpecialCheckVo> saveVo(@ApiParam(name = "bizBridgeSpecialCheckVo", value = "桥梁专项检查对象") @RequestBody BizBridgeSpecialCheckVo bizBridgeSpecialCheckVo) throws Exception {
        String msg = "添加成功";
        BizBridgeSpecialCheck bizBridgeSpecialCheck = bizBridgeSpecialCheckVo.getBizBridgeSpecialCheck();
        if (StringUtils.isEmpty(bizBridgeSpecialCheck.getId())) {
            bizBridgeSpecialCheck.setIsDele("0");
            baseService.saveVo(bizBridgeSpecialCheckVo);
        } else {
            baseService.updateVo(bizBridgeSpecialCheckVo);
            msg = "修改成功";
        }
        return new CommonResult<BizBridgeSpecialCheckVo>(true,msg,bizBridgeSpecialCheckVo);
    }




    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询桥梁专项检查信息",httpMethod = "POST")
    public PageList<BizBridgeSpecialCheck> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizBridgeSpecialCheck> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<BizBridgeSpecialCheck> pageList = baseService.queryBizBridgeSpecialCheck(queryFilter);
        return pageList;
    }


    @GetMapping(value="get/{id}")
    @ApiOperation(value="根据ID查询桥梁专项检查信息",httpMethod = "GET",notes = "根据ID查询桥梁专项检查信息")
    public BizBridgeSpecialCheck get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getBizBridgeSpecialById(id);
    }
    @GetMapping(value="getVo/{id}")
    @ApiOperation(value="根据ID查询桥梁专项检查、附件信息",httpMethod = "GET",notes = "根据ID查询桥梁专项检查、附件信息")
    public BizBridgeSpecialCheckVo getVo(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getVo(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除桥梁专项检查信息", httpMethod = "DELETE", notes = "批量删除桥梁专项检查信息")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value = "/updateBridge", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除桥梁专项检查信息", httpMethod = "DELETE", notes = "逻辑删除桥梁专项检查信息")
    public CommonResult<String> updateBridge(@ApiParam(name = "ids", value = "ID集合以，隔开", required = true)
                                             @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizBridgeSpecialCheck> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }

}
