package com.artfess.yhxt.contract.vo;

import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.contract.model.Contract;
import com.artfess.yhxt.contract.model.ContractItem;
import com.artfess.yhxt.contract.model.ContractPayment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author zhx
 * @create 2021/8/7
 */
@Data
@ApiModel(value="Contract vo对象", description="合同表、合同明细表、合同支付表")
public class ContractVo {
    @ApiModelProperty(value = "合同实体")
    private Contract contract;

    @ApiModelProperty(value = "合同明细实体")
    private List<ContractItem> itemList;

    @ApiModelProperty(value = "合同支付实体")
    private List<ContractPayment> paymentList;

    @ApiModelProperty(value = "附件")
    private List<Accessory> accessories;
}
