package com.artfess.yhxt.check.regular.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 涵洞定期检查表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-17
 */
@ApiModel(value="CulvertRegularCheck对象", description="涵洞定期检查表")
@TableName("biz_culvert_regular_check")
public class CulvertRegularCheck extends BizModel<CulvertRegularCheck> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "涵洞id")
    @TableField("CULVERT_ID_")
    private String culvertId;

    @ApiModelProperty(value = "涵洞名称")
    @TableField("CULVERT_NAME_")
    private String culvertName;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "检查人")
    @TableField("RUMMAGER_")
    private String rummager;

    @ApiModelProperty(value = "检查日期")
    @TableField("CHECK_DATE_")
    private LocalDate checkDate;

    @ApiModelProperty(value = "记录人")
    @TableField("NOTE_TAKER_")
    private String noteTaker;

    @ApiModelProperty(value = "总体评价")
    @TableField("EVALUATE_")
    private String evaluate;

    @ApiModelProperty(value = "总体评价值")
    @TableField("EVALUATE_VALUE_")
    private String evaluateValue;

    @ApiModelProperty(value = "养护方案")
    @TableField("MAINTAIN_SCHEME_")
    private String maintainScheme;

    @ApiModelProperty(value = "养护方案值")
    @TableField("MAINTAIN_SCHEME_VAULE_")
    private String maintainSchemeVaule;

    @ApiModelProperty(value = "下次检查日期")
    @TableField("NEXT_CHECK_DATE_")
    private LocalDate nextCheckDate;

    @ApiModelProperty(value = "附件地址")
    @TableField("URL_")
    private String url;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "检查明细")
    @TableField("CHECK_DETAIL_JSON_")
    private String checkDetailJson;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getCulvertId() {
        return culvertId;
    }

    public void setCulvertId(String culvertId) {
        this.culvertId = culvertId;
    }
    public String getCulvertName() {
        return culvertName;
    }

    public void setCulvertName(String culvertName) {
        this.culvertName = culvertName;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public String getRummager() {
        return rummager;
    }

    public void setRummager(String rummager) {
        this.rummager = rummager;
    }
    public LocalDate getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(LocalDate checkDate) {
        this.checkDate = checkDate;
    }
    public String getNoteTaker() {
        return noteTaker;
    }

    public void setNoteTaker(String noteTaker) {
        this.noteTaker = noteTaker;
    }
    public String getEvaluate() {
        return evaluate;
    }

    public void setEvaluate(String evaluate) {
        this.evaluate = evaluate;
    }
    public String getEvaluateValue() {
        return evaluateValue;
    }

    public void setEvaluateValue(String evaluateValue) {
        this.evaluateValue = evaluateValue;
    }
    public String getMaintainScheme() {
        return maintainScheme;
    }

    public void setMaintainScheme(String maintainScheme) {
        this.maintainScheme = maintainScheme;
    }
    public String getMaintainSchemeVaule() {
        return maintainSchemeVaule;
    }

    public void setMaintainSchemeVaule(String maintainSchemeVaule) {
        this.maintainSchemeVaule = maintainSchemeVaule;
    }
    public LocalDate getNextCheckDate() {
        return nextCheckDate;
    }

    public void setNextCheckDate(LocalDate nextCheckDate) {
        this.nextCheckDate = nextCheckDate;
    }
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public String getCheckDetailJson() {
        return checkDetailJson;
    }

    public void setCheckDetailJson(String checkDetailJson) {
        this.checkDetailJson = checkDetailJson;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "CulvertRegularCheck{" +
            "id=" + id +
            ", culvertId=" + culvertId +
            ", culvertName=" + culvertName +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
            ", rummager=" + rummager +
            ", checkDate=" + checkDate +
            ", noteTaker=" + noteTaker +
            ", evaluate=" + evaluate +
            ", evaluateValue=" + evaluateValue +
            ", maintainScheme=" + maintainScheme +
            ", maintainSchemeVaule=" + maintainSchemeVaule +
            ", nextCheckDate=" + nextCheckDate +
            ", url=" + url +
            ", remarks=" + remarks +
            ", checkDetailJson=" + checkDetailJson +

        "}";
    }
}
