package com.artfess.yhxt.basedata.manager;

import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.model.BizEmergeMaterialManagement;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.basedata.vo.BizEmergeMaterialManagementVO;
import com.artfess.yhxt.contract.vo.BizEmergeMaterialManagementGoodsVo;
import com.artfess.yhxt.statistics.vo.Org4culvertVO;
import com.artfess.yhxt.statistics.vo.Org4emergeVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 应急物资库管理 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xmz
 * @since 2022-04-19
 */
public interface BizEmergeMaterialManagementManager extends BaseManager<BizEmergeMaterialManagement> {


    PageList<BizEmergeMaterialManagementVO> queryEmergeMaterialManagement(QueryFilter<BizEmergeMaterialManagement> queryFilter);

    List<Org4emergeVO> getEmergeCount();

    /**
     * 保存或更新应急物资库及物品清单
     * @param vo
     */
    void saveOrUpdateManagementGoodsVo(BizEmergeMaterialManagementGoodsVo vo);

    CommonResult<String> importData(String manId, MultipartFile file);

}
