package com.artfess.yhxt.basedata.manager;

import com.artfess.yhxt.basedata.model.BizCourseDetails;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;


import java.util.List;

/**
 * 科目明细表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-07-30
 */
public interface BizCourseDetailsManager extends BaseManager<BizCourseDetails> {
    /**
     * @Description: 不分页查询科目明细
     * @Param: sysActuator
     * @Return: java.util.List<com.artfess.portal.model.SysActuator>
     * @Author: wp
     * @Date: 2021/7/15
     */
    PageList<BizCourseDetails> queryBizCourseDetails(QueryFilter<BizCourseDetails> queryFilter);
    /**
     * 逻辑删除
     * @param id
     */

    void updateBizCourseDetails(String id);

    List<BizCourseDetails> getByParentId(String subjectCode);

    /**
     * 通过Pcode修改hasChildren
     * @param pcode
     */
    void updateByPcode(String pcode);

    void checkCode(BizCourseDetails bizCourseDetails);


    void updateHasChildren(String ids);

    /**
     * 检查是否有子节点
     * @param idsList
     */
    void checkHasChildren(List<String> idsList);

    /**
     * 根据编码查询科目name
     * @param code
     * @return
     */
    String getByName(String code);

    List<BizCourseDetails> getByParentIdRoad(String pCode, String roadSegmentId);
}
