/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.typehandle;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={Object.class})
@MappedJdbcTypes(value={JdbcType.TIMESTAMP})
public class MyObjectTypeHandle
extends BaseTypeHandler<Object> {
    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        if (parameter instanceof LocalDateTime) {
            parameter = Timestamp.valueOf((LocalDateTime)parameter);
        }
        ps.setObject(i, parameter);
    }

    public Object getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Object result = rs.getObject(columnName);
        return rs.wasNull() ? null : this.dealResult(result);
    }

    public Object getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Object result = rs.getObject(columnIndex);
        return rs.wasNull() ? null : this.dealResult(result);
    }

    public Object getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object result = cs.getObject(columnIndex);
        return cs.wasNull() ? null : this.dealResult(result);
    }

    private Object dealResult(Object result) throws SQLException {
        if (result instanceof TIMESTAMP) {
            return new Date(((TIMESTAMP)result).dateValue().getTime());
        }
        if (result instanceof DATE) {
            return new Date(((DATE)result).dateValue().getTime());
        }
        if (result instanceof TIMESTAMPLTZ) {
            return new Date(((TIMESTAMPLTZ)result).dateValue().getTime());
        }
        if (result instanceof TIMESTAMPTZ) {
            return new Date(((TIMESTAMPTZ)result).dateValue().getTime());
        }
        return result;
    }
}

