package com.artfess.yhxt.statistics.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-10-26
 */
@ApiModel(value="WorkeStatistic对象", description="大屏养护工单统计")
@TableName("biz_work_statistic")
public class WorkStatistic extends BaseModel<WorkStatistic> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "月份（2021-08）")
    @TableField("ACC_DATE_MONTH_")
    private String accDateMonth;

    @ApiModelProperty(value = "年份（2021）")
    @TableField("ACC_DATE_YEAR_")
    private String accDateYear;

    @ApiModelProperty(value = "每月工单数量")
    @TableField("TOTAL_NUMS_")
    private String totalNums;

//    @ApiModelProperty(value = "完成数量")
//    @TableField(exist = false)
//    private Integer total=0;
    @ApiModelProperty(value = "未完成数量")
    @TableField("TOTAL_NUMS_NO_")
    private String totalNumsNo ="0";

    public String getTotalNumsNo() {
        return totalNumsNo;
    }

    public void setTotalNumsNo(String totalNumsNo) {
        this.totalNumsNo = totalNumsNo;
    }

//    public Integer getTotal() {
//        return total;
//    }
//
//    public void setTotal(Integer total) {
//        this.total = total;
//    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public String getRoadSegmentId() {
        return roadSegmentId;
    }

    public void setRoadSegmentId(String roadSegmentId) {
        this.roadSegmentId = roadSegmentId;
    }
    public String getRoadSegmentName() {
        return roadSegmentName;
    }

    public void setRoadSegmentName(String roadSegmentName) {
        this.roadSegmentName = roadSegmentName;
    }
    public String getAccDateMonth() {
        return accDateMonth;
    }

    public void setAccDateMonth(String accDateMonth) {
        this.accDateMonth = accDateMonth;
    }
    public String getAccDateYear() {
        return accDateYear;
    }

    public void setAccDateYear(String accDateYear) {
        this.accDateYear = accDateYear;
    }
    public String getTotalNums() {
        return totalNums;
    }

    public void setTotalNums(String totalNums) {
        this.totalNums = totalNums;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizWorkeStatistic{" +
            "id=" + id +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
            ", roadSegmentId=" + roadSegmentId +
            ", roadSegmentName=" + roadSegmentName +
            ", accDateMonth=" + accDateMonth +
            ", accDateYear=" + accDateYear +
            ", totalNums=" + totalNums +
        "}";
    }
}
