package com.artfess.yhxt.specialproject.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.ProjectOverApplyFor;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.specialproject.vo.ProjectOverApplyForVo;

/**
 * 项目交工申请表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-18
 */
public interface ProjectOverApplyForManager extends BaseManager<ProjectOverApplyFor> {

    /**
     * 分页查询项目交工
     * @param queryFilter
     * @return
     */
    PageList<ProjectOverApplyFor> queryProjectOverApplyFor(QueryFilter<ProjectOverApplyFor> queryFilter);

    /**
     * 保存接口
     * @param projectOverApplyFor
     */
    void saveProjectOverApplyFor(ProjectOverApplyFor projectOverApplyFor);

    /**
     * 修改接口
     * @param projectOverApplyFor
     */
    void updateProjectOverApplyFor(ProjectOverApplyFor projectOverApplyFor);

    /**
     *业主方
     * @param ids
     */
    void ownerUserAudit(String ids,String ownerDescription ,Integer confirmStatu);

    /**
     * 监理方
     * @param ids
     */
     void confirmUserAudit(String ids,String confirmDescription ,Integer confirmStatus);

    /**
     * 保存交工信息
     * @param projectOverApplyForVo
     */
    void saveVo(ProjectOverApplyForVo projectOverApplyForVo);

    /**
     * 修改交工信息
     * @param projectOverApplyForVo
     */
    void updateVo(ProjectOverApplyForVo projectOverApplyForVo);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    ProjectOverApplyForVo getVo(String id);
}
