package com.artfess.yhxt.specialproject.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.ProjectAcceptance;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.specialproject.vo.ProjectAcceptanceVo;
import com.artfess.yhxt.specialproject.vo.ProjectOverApplyForVo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 *  服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-19
 */
public interface ProjectAcceptanceManager extends BaseManager<ProjectAcceptance> {

    PageList<ProjectAcceptance> queryProjectAcceptance(QueryFilter<ProjectAcceptance> queryFilter);

    /**
     * 上传文件
     * @param file
     * @param sourceId
     * @return
     */
    BizEngineeringAccessories minioAcceptanceUpload(MultipartFile file, String sourceId);

    /**
     * 删除文件
     * @param asList
     */
    void minioAcceptanceDel(List<String> asList);

    void minIoAcceptanceDownFile(String ids, HttpServletResponse response) throws Exception;

    /**
     *保存
     * @param projectAcceptanceVo
     */
    void saveVo(ProjectAcceptanceVo projectAcceptanceVo);

    /**
     * 修改
     * @param projectAcceptanceVo
     */
    void updateVo(ProjectAcceptanceVo projectAcceptanceVo);

    /**
     * 根据id查询信息
     * @param id
     * @return
     */
    ProjectAcceptanceVo getVo(String id);
}
