package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.uc.util.ContextUtil;
import com.artfess.yhxt.specialproject.model.BizProjectBidding;
import com.artfess.yhxt.specialproject.vo.BizProjectBiddingVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.BizProjectBidding;
import com.artfess.yhxt.specialproject.manager.BizProjectBiddingManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

/**
 * 项目招投标信息表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-17
 */
@RestController
@RequestMapping("/bizProjectBidding/v1/")
@Api(tags = "项目招投标信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizProjectBiddingController extends BaseController<BizProjectBiddingManager, BizProjectBidding> {

    @Resource
    private BaseContext baseContext;
    @Resource
    private PermissionUtils permissionUtils;

    @RequestMapping(value = "/saveProjectCompletionApplicationForm",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改项目招投标信息",httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizProjectBidding",value = "项目招投标专项检查对象") @RequestBody BizProjectBidding bizProjectBidding) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizProjectBidding.getId())){
            bizProjectBidding.setIsDele("0");
            baseService.create(bizProjectBidding);
        }else {
            baseService.update(bizProjectBidding);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value = "/saveVo",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改项目招投标、附件信息",httpMethod = "POST")
    public CommonResult<String> saveVo(@ApiParam(name = "bizProjectBiddingVo",value = "项目招投标专项检查对象") @RequestBody BizProjectBiddingVo bizProjectBiddingVo) throws Exception {
        String msg = "添加成功";
        BizProjectBidding bizProjectBidding = bizProjectBiddingVo.getBizProjectBidding();
        if (StringUtils.isEmpty(bizProjectBidding.getId())){
            bizProjectBidding.setIsDele("0");
            baseService.saveVo(bizProjectBiddingVo);
        }else {
            baseService.updateVo(bizProjectBiddingVo);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @GetMapping(value = "getVo/{id}")
    @ApiOperation(value = "根据ID查询项目招投标、附件信息",httpMethod = "GET",notes = "根据ID查询项目招投标信息")
    public BizProjectBiddingVo getVo(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getVo(id);
    }

    @RequestMapping(value = "/getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询项目招投标信息",httpMethod ="POST")
    public PageList<BizProjectBidding> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizProjectBidding> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
        PageList<BizProjectBidding> pageList = baseService.queryBizProjectBidding(queryFilter);
        return pageList;
    }

    @RequestMapping(value = "/getQuery",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询项目招投标信息",httpMethod ="POST")
    public PageList<BizProjectBidding> getQuery(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizProjectBidding> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
        PageList<BizProjectBidding> pageList = baseService.query(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询项目招投标信息",httpMethod = "GET",notes = "根据ID查询项目招投标信息")
    public BizProjectBidding get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizProjectBiddingById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除项目招投标信息",httpMethod = "DELETE",notes = "批量删除项目招投标信息")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateBidding",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除项目招投标信息",httpMethod = "DELETE",notes = "逻辑删除项目招投标信息")
    public CommonResult<String> updateBidding(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizProjectBidding> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }
    @PostMapping("/minioUpload")
    @ApiOperation(value = "上传")
    public String minioUpload(MultipartFile file){
        String fileurl =baseService.minioUpload(file);
        return fileurl;
    }
}
