package com.artfess.yhxt.specialcheck.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 桥梁专项检查表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@ApiModel(value="BizBridgeSpecialCheck对象", description="桥梁专项检查表")
@TableName("biz_bridge_special_check")
public class BizBridgeSpecialCheck extends BizModel<BizBridgeSpecialCheck> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId("ID_")
    private String id;

    @ApiModelProperty(value = "桥梁id")
    @TableField("BRIGE_ID_")
    private String brigeId;

    @ApiModelProperty(value = "桥梁名称")
    @TableField("BRIGE_NAME_")
    private String brigeName;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "检查单位")
    @TableField("CHECK_UNIT_")
    private String checkUnit;

    @ApiModelProperty(value = "检查日期")
    @TableField("CHECK_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date checkDate;

    @ApiModelProperty(value = "经办人")
    @TableField("OPERATOR_")
    private String operator;

    @ApiModelProperty(value = "检查人")
    @TableField("RUMMAGER_")
    private String rummager;

    @ApiModelProperty(value = "检查内容")
    @TableField("CHECK_CONTENT_")
    private String checkContent;

    @ApiModelProperty(value = "检查结论")
    @TableField("CHECK_CONCLUSION_")
    private String checkConclusion;

    @ApiModelProperty(value = "处置建议")
    @TableField("DISPOSAL_SUGGESTION_")
    private String disposalSuggestion;

    @ApiModelProperty(value = "附件地址")
    @TableField("URL_")
    private String url;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getBrigeId() {
        return brigeId;
    }

    public void setBrigeId(String brigeId) {
        this.brigeId = brigeId;
    }
    public String getBrigeName() {
        return brigeName;
    }

    public void setBrigeName(String brigeName) {
        this.brigeName = brigeName;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public String getCheckUnit() {
        return checkUnit;
    }

    public void setCheckUnit(String checkUnit) {
        this.checkUnit = checkUnit;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }
    public String getRummager() {
        return rummager;
    }

    public void setRummager(String rummager) {
        this.rummager = rummager;
    }
    public String getCheckContent() {
        return checkContent;
    }

    public void setCheckContent(String checkContent) {
        this.checkContent = checkContent;
    }
    public String getCheckConclusion() {
        return checkConclusion;
    }

    public void setCheckConclusion(String checkConclusion) {
        this.checkConclusion = checkConclusion;
    }
    public String getDisposalSuggestion() {
        return disposalSuggestion;
    }

    public void setDisposalSuggestion(String disposalSuggestion) {
        this.disposalSuggestion = disposalSuggestion;
    }
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }


    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "BizBridgeSpecialCheck{" +
            "id=" + id +
            ", brigeId=" + brigeId +
            ", brigeName=" + brigeName +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
            ", checkUnit=" + checkUnit +
            ", checkDate=" + checkDate +
            ", operator=" + operator +
            ", rummager=" + rummager +
            ", checkContent=" + checkContent +
            ", checkConclusion=" + checkConclusion +
            ", disposalSuggestion=" + disposalSuggestion +
            ", url=" + url +
        "}";
    }
}
