package com.artfess.yhxt.check.regular.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 边坡定期检查表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-17
 */
@ApiModel(value="SideSlopeRegularCheck对象", description="边坡定期检查表")
@TableName("biz_side_slope_regular_check")
public class SideSlopeRegularCheck extends BaseModel<SideSlopeRegularCheck> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "边坡id")
    @TableField("SIDE_SLOPE_ID_")
    private String sideSlopeId;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "上次大中修日期")
    @TableField("LAST_REPAIR_DATE_")
    private LocalDate lastRepairDate;

    @ApiModelProperty(value = "上次检查日期")
    @TableField("LAST_CHECK_DATE_")
    private LocalDate lastCheckDate;

    @ApiModelProperty(value = "本次检查日期")
    @TableField("CHECK_DATE_")
    private LocalDate checkDate;

    @ApiModelProperty(value = "天气")
    @TableField("WEATHER_")
    private String weather;

    @ApiModelProperty(value = "总体状况评定等级")
    @TableField("OVERALL_RATING_")
    private String overallRating;

    @ApiModelProperty(value = "总体评价")
    @TableField("EVALUATE_")
    private String evaluate;

    @ApiModelProperty(value = "记录人")
    @TableField("NOTE_TAKER_")
    private String noteTaker;

    @ApiModelProperty(value = "负责人")
    @TableField("PERSON_IN_CHARGE_")
    private String personInCharge;

    @ApiModelProperty(value = "下次检查日期")
    @TableField("NEXT_CHECK_DATE_")
    private String nextCheckDate;

    @ApiModelProperty(value = "处置情况")
    @TableField("PROCESSING_")
    private String processing;

    @ApiModelProperty(value = "附件地址")
    @TableField("URL_")
    private String url;

    @ApiModelProperty(value = "天气值")
    @TableField("WEATHER_VALUE_")
    private String weatherValue;

    @ApiModelProperty(value = "总体状况评定等级值")
    @TableField("OVERALL_RATING_VALUE_")
    private String overallRatingValue;

    @ApiModelProperty(value = "检查明细")
    @TableField("CHCEK_DETAIL_JSON_")
    private String chcekDetailJson;

    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建人单位ID")
    @TableField("CREATE_COMPANY_ID_")
    private String createCompanyId;

    @ApiModelProperty(value = "创建人单位名称")
    @TableField("CREATE_COMPANY_NAME_")
    private String createCompanyName;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人单位名称")
    @TableField("UPDATE_COMPANY_NAME_")
    private String updateCompanyName;

    @ApiModelProperty(value = "更新人单位ID")
    @TableField("UPDATE_COMPANY_ID_")
    private String updateCompanyId;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getSideSlopeId() {
        return sideSlopeId;
    }

    public void setSideSlopeId(String sideSlopeId) {
        this.sideSlopeId = sideSlopeId;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public LocalDate getLastRepairDate() {
        return lastRepairDate;
    }

    public void setLastRepairDate(LocalDate lastRepairDate) {
        this.lastRepairDate = lastRepairDate;
    }
    public LocalDate getLastCheckDate() {
        return lastCheckDate;
    }

    public void setLastCheckDate(LocalDate lastCheckDate) {
        this.lastCheckDate = lastCheckDate;
    }
    public LocalDate getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(LocalDate checkDate) {
        this.checkDate = checkDate;
    }
    public String getWeather() {
        return weather;
    }

    public void setWeather(String weather) {
        this.weather = weather;
    }
    public String getOverallRating() {
        return overallRating;
    }

    public void setOverallRating(String overallRating) {
        this.overallRating = overallRating;
    }
    public String getEvaluate() {
        return evaluate;
    }

    public void setEvaluate(String evaluate) {
        this.evaluate = evaluate;
    }
    public String getNoteTaker() {
        return noteTaker;
    }

    public void setNoteTaker(String noteTaker) {
        this.noteTaker = noteTaker;
    }
    public String getPersonInCharge() {
        return personInCharge;
    }

    public void setPersonInCharge(String personInCharge) {
        this.personInCharge = personInCharge;
    }
    public String getNextCheckDate() {
        return nextCheckDate;
    }

    public void setNextCheckDate(String nextCheckDate) {
        this.nextCheckDate = nextCheckDate;
    }
    public String getProcessing() {
        return processing;
    }

    public void setProcessing(String processing) {
        this.processing = processing;
    }
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
    public String getWeatherValue() {
        return weatherValue;
    }

    public void setWeatherValue(String weatherValue) {
        this.weatherValue = weatherValue;
    }
    public String getOverallRatingValue() {
        return overallRatingValue;
    }

    public void setOverallRatingValue(String overallRatingValue) {
        this.overallRatingValue = overallRatingValue;
    }
    public String getChcekDetailJson() {
        return chcekDetailJson;
    }

    public void setChcekDetailJson(String chcekDetailJson) {
        this.chcekDetailJson = chcekDetailJson;
    }
    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }
    public String getCreateOrgName() {
        return createOrgName;
    }

    public void setCreateOrgName(String createOrgName) {
        this.createOrgName = createOrgName;
    }
    public String getCreateCompanyId() {
        return createCompanyId;
    }

    public void setCreateCompanyId(String createCompanyId) {
        this.createCompanyId = createCompanyId;
    }
    public String getCreateCompanyName() {
        return createCompanyName;
    }

    public void setCreateCompanyName(String createCompanyName) {
        this.createCompanyName = createCompanyName;
    }
    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }
    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }
    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }
    public String getUpdateCompanyName() {
        return updateCompanyName;
    }

    public void setUpdateCompanyName(String updateCompanyName) {
        this.updateCompanyName = updateCompanyName;
    }
    public String getUpdateCompanyId() {
        return updateCompanyId;
    }

    public void setUpdateCompanyId(String updateCompanyId) {
        this.updateCompanyId = updateCompanyId;
    }
    public String getUpdateOrgId() {
        return updateOrgId;
    }

    public void setUpdateOrgId(String updateOrgId) {
        this.updateOrgId = updateOrgId;
    }
    public String getUpdateOrgName() {
        return updateOrgName;
    }

    public void setUpdateOrgName(String updateOrgName) {
        this.updateOrgName = updateOrgName;
    }
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }
    public Long getLastTime() {
        return lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }
    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }
    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "SideSlopeRegularCheck{" +
            "id=" + id +
            ", sideSlopeId=" + sideSlopeId +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
            ", lastRepairDate=" + lastRepairDate +
            ", lastCheckDate=" + lastCheckDate +
            ", checkDate=" + checkDate +
            ", weather=" + weather +
            ", overallRating=" + overallRating +
            ", evaluate=" + evaluate +
            ", noteTaker=" + noteTaker +
            ", personInCharge=" + personInCharge +
            ", nextCheckDate=" + nextCheckDate +
            ", processing=" + processing +
            ", url=" + url +
            ", weatherValue=" + weatherValue +
            ", overallRatingValue=" + overallRatingValue +
            ", chcekDetailJson=" + chcekDetailJson +
            ", createBy=" + createBy +
            ", createOrgName=" + createOrgName +
            ", createCompanyId=" + createCompanyId +
            ", createCompanyName=" + createCompanyName +
            ", createName=" + createName +
            ", createOrgId=" + createOrgId +
            ", createTime=" + createTime +
            ", updateBy=" + updateBy +
            ", updateName=" + updateName +
            ", updateCompanyName=" + updateCompanyName +
            ", updateCompanyId=" + updateCompanyId +
            ", updateOrgId=" + updateOrgId +
            ", updateOrgName=" + updateOrgName +
            ", updateTime=" + updateTime +
            ", lastTime=" + lastTime +
            ", isDele=" + isDele +
            ", version=" + version +
            ", tenantId=" + tenantId +
        "}";
    }
}
