package com.artfess.yhxt.check.regular.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.check.regular.model.TunnelOftenCheck;
import com.artfess.yhxt.check.regular.vo.TunnelOftenCheckVo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 隧道经常检查表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-04
 */
public interface TunnelOftenCheckManager extends BaseManager<TunnelOftenCheck> {

    /**
     * 分页查询隧道经常检查信息
     * @param queryFilter
     * @return
     */
    PageList<TunnelOftenCheck> queryTunnelOftenCheck(QueryFilter<TunnelOftenCheck> queryFilter);

    /**
     * 保存隧道经常检查信息和明细
     * @param vo
     */
    void saveTunnelOftenCheck(TunnelOftenCheckVo vo);
    /**
     * 修改隧道经常检查信息和明细
     * @param vo
     */
    void updateTunnelOftenCheck(TunnelOftenCheckVo vo);

    /**
     * 根据id隧道经常检查信息和明细
     * @param id
     * @return
     */
    TunnelOftenCheckVo getTunnelOftenCheckById(String id);

    void importExcelData(MultipartFile file, TunnelOftenCheck parseObject);
}
