package com.artfess.yhxt.check.detail.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 隧道经常检查明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-04
 */
@ApiModel(value="TunnelOftenCheckDetail对象", description="隧道经常检查明细表")
@TableName("BIZ_TUNNEL_OFTEN_CHECK_DETAIL")
public class TunnelOftenCheckDetail extends BaseModel<TunnelOftenCheckDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "隧道经常检查表ID")
    @TableField("TUNNEL_OFTEN_CHECK_ID_")
    private String tunnelOftenCheckId;

    @Excel(name = "结构名称", orderNum = "1")
    @ApiModelProperty(value = "结构名称")
    @TableField("UNIT_NAME_")
    private String unitName;

    @Excel(name = "里程桩号/异常位置", orderNum = "0")
    @ApiModelProperty(value = "里程桩号/异常位置")
    @TableField("MILEAGE_PILENUM_")
    private String mileagePilenum;

    @Excel(name = "检查内容", orderNum = "2")
    @ApiModelProperty(value = "检查内容")
    @TableField("CHECK_CONTENT_")
    private String checkContent;

    @Excel(name = "状态描述", orderNum = "3")
    @ApiModelProperty(value = "状态描述")
    @TableField("STATUS_DESC_")
    private String statusDesc;

    @Excel(name = "判断", orderNum = "4")
    @ApiModelProperty(value = "判断")
    @TableField("FLAG_")
    private String flag;

    @Excel(name = "备注", orderNum = "5")
    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getTunnelOftenCheckId() {
        return tunnelOftenCheckId;
    }

    public void setTunnelOftenCheckId(String tunnelOftenCheckId) {
        this.tunnelOftenCheckId = tunnelOftenCheckId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getMileagePilenum() {
        return mileagePilenum;
    }

    public void setMileagePilenum(String mileagePilenum) {
        this.mileagePilenum = mileagePilenum;
    }
    public String getCheckContent() {
        return checkContent;
    }

    public void setCheckContent(String checkContent) {
        this.checkContent = checkContent;
    }
    public String getStatusDesc() {
        return statusDesc;
    }

    public void setStatusDesc(String statusDesc) {
        this.statusDesc = statusDesc;
    }
    public String getFlag() {
        return flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "TunnelOftenCheckDetail{" +
            "id=" + id +
            ", tunnelOftenCheckId=" + tunnelOftenCheckId +
            ", unitName=" + unitName +
            ", mileagePilenum=" + mileagePilenum +
            ", checkContent=" + checkContent +
            ", statusDesc=" + statusDesc +
            ", flag=" + flag +
            ", remarks=" + remarks +
        "}";
    }
}
