package com.artfess.yhxt.check.detail.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 涵洞定期检查明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-17
 */
@ApiModel(value="CulvertRegularCheckDetail对象", description="涵洞定期检查明细表")
@TableName("biz_culvert_regular_check_detail")
public class CulvertRegularCheckDetail extends BaseModel<CulvertRegularCheckDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "涵洞定期检查明细表")
    @TableField("CULVERT_REGULAR_CHECK_ID_")
    private String culvertRegularCheckId;

    @Excel(name = "结构名称", orderNum = "0")
    @ApiModelProperty(value = "结构名称")
    @TableField("UNIT_NAME_")
    private String unitName;

    @Excel(name = "检查内容", orderNum = "1")
    @ApiModelProperty(value = "检查内容")
    @TableField("CHECK_CONTENT_")
    private String checkContent;

    @Excel(name = "损坏或需维修情况描述", orderNum = "2")
    @ApiModelProperty(value = "损坏或需维修情况描述")
    @TableField("REPAIR_DESC_")
    private String repairDesc;

    @Excel(name = "维修建议", orderNum = "3")
    @ApiModelProperty(value = "维修建议")
    @TableField("MAINTAIN_ADVICE_")
    private String maintainAdvice;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getCulvertRegularCheckId() {
        return culvertRegularCheckId;
    }

    public void setCulvertRegularCheckId(String culvertRegularCheckId) {
        this.culvertRegularCheckId = culvertRegularCheckId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getCheckContent() {
        return checkContent;
    }

    public void setCheckContent(String checkContent) {
        this.checkContent = checkContent;
    }
    public String getRepairDesc() {
        return repairDesc;
    }

    public void setRepairDesc(String repairDesc) {
        this.repairDesc = repairDesc;
    }
    public String getMaintainAdvice() {
        return maintainAdvice;
    }

    public void setMaintainAdvice(String maintainAdvice) {
        this.maintainAdvice = maintainAdvice;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "CulvertRegularCheckDetail{" +
            "id=" + id +
            ", culvertRegularCheckId=" + culvertRegularCheckId +
            ", unitName=" + unitName +
            ", checkContent=" + checkContent +
            ", repairDesc=" + repairDesc +
            ", maintainAdvice=" + maintainAdvice +
        "}";
    }
}
