package com.artfess.yhxt.basedata.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 边坡信息表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 向贞好
 * @since 2021-07-28
 */
@ApiModel(value="BizSideSlopeInformation对象", description="边坡信息表")
@TableName("BIZ_SIDE_SLOPE_INFORMATION")
@Data
@JsonInclude
public class SideSlopeInformation extends BizModel<SideSlopeInformation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司id")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "所属公司多个ID")
    @TableField("COMPANY_IDS_")
    private String companyIds;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "编号")
    @TableField("NUMBER_")
    private String number;

    @ApiModelProperty(value = "所在路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "管养单位ID")
    @TableField("OFFICE_ID_")
    private String officeId;

    @ApiModelProperty(value = "管养单位名称")
    @TableField("OFFICE_NAME_")
    private String officeName;

    @ApiModelProperty(value = "起点桩号")
    @TableField("START_PEG_")
    private Float startPeg;

    @ApiModelProperty(value = "方向 1:上行方向 2:下行方向 3:上下双向 4:匝道")
    @TableField("DIRECTION_")
    private String direction;

    @ApiModelProperty(value = "保护类型")
    @TableField("PROTECT_TYPE_")
    private String protectType;

    @ApiModelProperty(value = "保护材料")
    @TableField("PROTECT_MATERIAL_")
    private String protectMaterial;

    @ApiModelProperty(value = "高度")
    @TableField("HEIGHT_")
    private Float height;

    @ApiModelProperty(value = "长度")
    @TableField("LENGTH_")
    private Float length;

    @ApiModelProperty(value = "保护尺寸")
    @TableField("PROTECTIVE_DIMENSION_")
    private String protectiveDimension;

    @ApiModelProperty(value = "施工情况")
    @TableField("CONSTRUCTION_SITUATION_")
    private String constructionSituation;

    @ApiModelProperty(value = "地质")
    @TableField("GEOLOGY_")
    private String geology;

    @ApiModelProperty(value = "是否高边坡(1 高边坡，0 其他边坡)")
    @TableField("IS_HIGH_RISK_")
    private String isHighRisk;

    @ApiModelProperty(value = "是否斜坡(1 是0 否)")
    @TableField("IS_RAMP_")
    private String isRamp;

    @ApiModelProperty(value = "X")
    @TableField("X_")
    private String x;

    @ApiModelProperty(value = "Y")
    @TableField("Y_")
    private String y;

    @ApiModelProperty(value = "起点桩号KM")
    @TableField("START_PEG_K_")
    private String startPegK;

    @ApiModelProperty(value = "止点桩号KM")
    @TableField("END_PEG_K_")
    private String endPegK;

    @ApiModelProperty(value = "止点桩号")
    @TableField("END_PEG_")
    private String endPeg;

    @ApiModelProperty(value = "方向值")
    @TableField("DIRECTION_VALUE_")
    private String directionValue;


    @ApiModelProperty(value = "经度")
    @TableField("LNG")
    private Double lng;
    @ApiModelProperty(value = "维度")
    @TableField("LAT")
    private Double lat;

    //正面图:frontView  侧面图:lateralView 二维平面图:twoDimensionalPlan
    @ApiModelProperty(value = "正面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesFrontView;
    @ApiModelProperty(value = "侧面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesLateralView;
    @ApiModelProperty(value = "二维平面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesTwoDimensionalView;

//    @ApiModelProperty(value = "路段")
//    @TableField(exist = false)
//    private Road road;
}
