/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.form.model.ComponentFunctionEntity;
import com.artfess.form.persistence.dao.ComponentFunctionDao;
import com.artfess.form.persistence.manager.ComponentFunctionManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ComponentFunctionServiceImpl
extends BaseManagerImpl<ComponentFunctionDao, ComponentFunctionEntity>
implements ComponentFunctionManager {
    @Autowired
    ComponentFunctionDao componentFunctionMapper;

    @Override
    @Transactional
    public String insertComponentFunction(ComponentFunctionEntity componentFunctionEntity) {
        Assert.notNull((Object)((Object)componentFunctionEntity), (String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
        Integer nextSequence = this.getNextSequence(null);
        componentFunctionEntity.setSn(nextSequence);
        this.checkValidity(componentFunctionEntity);
        this.componentFunctionMapper.insert((Object)componentFunctionEntity);
        return componentFunctionEntity.getId();
    }

    @Override
    @Transactional
    public String updateComponentFunction(ComponentFunctionEntity componentFunctionEntity) {
        Assert.notNull((Object)((Object)componentFunctionEntity), (String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
        this.checkValidity(componentFunctionEntity);
        this.componentFunctionMapper.updateById((Object)componentFunctionEntity);
        return componentFunctionEntity.getId();
    }

    @Override
    public ComponentFunctionEntity loadComponentFunction(String id) {
        Assert.hasText((String)id, (String)"\u53c2\u6570id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
        return (ComponentFunctionEntity)((Object)this.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public Integer deleteComponentFunction(String ids) {
        Assert.hasText((String)ids, (String)"\u53c2\u6570ids\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
        List<String> idsList = Arrays.asList(ids.split(","));
        return this.componentFunctionMapper.deleteBatchIds(idsList);
    }

    @Override
    public List<ComponentFunctionEntity> queryComponentFunction(ComponentFunctionEntity componentFunctionEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)componentFunctionEntity.getFunName()), (Object)"FUN_NAME", (Object)componentFunctionEntity.getFunName());
        queryWrapper.eq(Objects.nonNull(componentFunctionEntity.getFunType()), (Object)"FUN_TYPE", (Object)componentFunctionEntity.getFunType());
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)componentFunctionEntity.getFunQzCode()), (Object)"FUN_QZ_CODE", (Object)componentFunctionEntity.getFunQzCode());
        queryWrapper.orderByAsc((Object)"SEQUENCE");
        return this.componentFunctionMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    @Transactional
    public void updateComponentFunctionStatus(String ids, Integer status) {
        List<String> idsList = Arrays.asList(ids.split(","));
    }

    private void checkValidity(ComponentFunctionEntity componentFunctionEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)componentFunctionEntity.getFunName()), (Object)"FUN_NAME", (Object)componentFunctionEntity.getFunName());
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)componentFunctionEntity.getId()), (Object)"ID", (Object)componentFunctionEntity.getId());
        Integer count = this.componentFunctionMapper.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            throw new ApplicationException("\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
        }
    }
}

