package com.artfess.cqxy.processManagermant.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.annotation.BigDecimalFormat;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 过程管理 - 变更管理(BizChangeManagement)表实体类
 * @author 黎沐华
 * @since 2022-03-03 09:19:49
 */
@Data
@TableName("BIZ_CHANGE_MANAGEMENT")
@ApiModel(value="过程管理-变更管理对象-ChangeManagement", description="过程管理-变更管理表")
public class ChangeManagement extends BizModel<ChangeManagement> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

//    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的合同信息")
    private Contract contractInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name="变更编号")
    @TableField("CHANGE_CODE_")
    @ApiModelProperty(value = "变更编号，（由后台生成，生成格式：BGGL年月日+01，01表示按天自增）")
    private String changeCode;

    @Excel(name = "变更类型")
    @TableField("CHANGE_TYPE_")
    @ApiModelProperty(value = "变更类型，（使用字典：1：设计变更，2：施工变更，3：合同变更，4：其他）")
    private String changeType;

    @Excel(name = "审批机构")
    @TableField("TENDEREE_")
    @ApiModelProperty(value = "审批机构")
    private String tenderee;

    @Excel(name = "变更金额(万元)", numFormat = "#")
    @TableField("CHANGE_PRICE_")
    @ApiModelProperty(value = "变更金额（万元）")
    @BigDecimalFormat
    private BigDecimal changePrice;

    @Excel(name = "变更日期",format = "yyyy-MM-dd")
    @TableField("CHANGE_DATE_")
    @ApiModelProperty(value = "变更日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate;

    @Excel(name = "变更内容")
    @TableField("CHANGE_CONTENT_")
    @ApiModelProperty(value = "变更内容")
    private String changeContent;

    @Excel(name = "变更原因")
    @TableField("CHANGE_REASON_")
    @ApiModelProperty(value = "变更原因")
    private String changeReason;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

//    @Excel(name = "变更所属合同ID")
    @TableField("CHANGE_CONTRACT_ID_")
    @ApiModelProperty(value = "变更所属合同ID")
    private String changeContractId;

//    @Excel(name = "变更所属合同名称")
    @TableField("CHANGE_CONTRACT_NAME_")
    @ApiModelProperty(value = "变更所属合同名称")
    private String changeContractName;

//    @Excel(name = "提出变更单位")
    @TableField("CHANGE_UNIT_")
    @ApiModelProperty(value = "提出变更单位")
    private String changeUnit;

//    @Excel(name = "变更名称")
    @TableField("CHANGE_NAME_")
    @ApiModelProperty(value = "变更名称")
    private String changeName;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ChangeManagement{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", changeCode='" + changeCode + '\'' +
                ", changeName='" + changeName + '\'' +
                ", changeType=" + changeType +
                ", changeContractId='" + changeContractId + '\'' +
                ", changeContractName='" + changeContractName + '\'' +
                ", changeUnit='" + changeUnit + '\'' +
                ", changePrice='" + changePrice + '\'' +
                ", changeDate=" + changeDate +
                ", changeReason='" + changeReason + '\'' +
                ", changeContent='" + changeContent + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", contractInfo=" + contractInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }
}

