package com.artfess.cqxy.feasiblePlan.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 规划许可-工程规划表(BizPlanningEngineering)表实体类
 * 类型为规划许可时为规划许可，否则为专项审查
 * @author 黎沐华
 * @since 2022-02-15 15:14:13
 */
@Data
@TableName("BIZ_PLANNING_ENGINEERING")
@ApiModel(value="可研规划-规划许可-工程规划对象-PlanningEngineering", description="规划许可-工程规划表")
public class PlanningEngineering extends BizModel<PlanningEngineering> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "发证机关")
    @TableField("ESTABLISHMENT_APPROVAL_UNIT_")
    @ApiModelProperty(value = "发证机关")
    private String establishmentApprovalUnit;

    @Excel(name = "批复日期",format = "yyyy-MM-dd")
    @TableField("ESTABLISHMENT_DATE_")
    @ApiModelProperty(value = "批复日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate;

    @Value("1")
    @Excel(name = "类型")
    @TableField("TYPE_")
    @ApiModelProperty(value = "类型（使用字典：1：工程规划（(默认值），2：轨道，3：高压，4：行洪，5：其他）")
    private String type;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

//    @Excel(name = "名称")
    @TableField("NAME_")
    @ApiModelProperty(value = "名称")
    private String name;

//    @Excel(name = "文号")
    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "文号")
    private String documentNumber;

//    @Excel(name = "建设项目名称")
    @TableField("CONSTRUCTION_PROJECT_NAME_")
    @ApiModelProperty(value = "建设项目名称")
    private String constructionProjectName;

//    @Excel(name = "建设位置")
    @TableField("PROPOSED_LOCATION_")
    @ApiModelProperty(value = "建设位置")
    private String proposedLocation;

//    @Excel(name = "建设长度（单位：m）")
    @TableField("CONSTRUCTION_LENGTH_")
    @ApiModelProperty(value = "建设长度（单位：m）")
    private String constructionLength;

//    @Excel(name = "建设宽度（单位：m）")
    @TableField("CONSTRUCTION_WIDTH_")
    @ApiModelProperty(value = "建设宽度（单位：m）")
    private String constructionWidth;

//    @Excel(name = "设计时速(单位：km/h)")
    @TableField("DESIGN_SPEED_")
    @ApiModelProperty(value = "设计时速(单位：km/h)")
    private String designSpeed;

//    @Excel(name = "建设规模")
    @TableField("CONSTRUCTION_SCALE_")
    @ApiModelProperty(value = "建设规模")
    private String constructionScale;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "PlanningEngineering{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", type=" + type +
                ", name='" + name + '\'' +
                ", documentNumber='" + documentNumber + '\'' +
                ", establishmentApprovalUnit='" + establishmentApprovalUnit + '\'' +
                ", establishmentDate=" + establishmentDate +
                ", constructionProjectName='" + constructionProjectName + '\'' +
                ", proposedLocation='" + proposedLocation + '\'' +
                ", constructionLength='" + constructionLength + '\'' +
                ", constructionWidth='" + constructionWidth + '\'' +
                ", designSpeed='" + designSpeed + '\'' +
                ", constructionScale='" + constructionScale + '\'' +
                ", establishmentRemarks='" + establishmentRemarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

}

