package com.artfess.cqxy.completionAcceptance.dao;

import com.artfess.cqxy.completionAcceptance.model.AcceptanceFinalAccounts;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 竣工验收 - 决算表(BizAcceptanceFinalAccounts)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-03-07 15:52:28
 */
public interface AcceptanceFinalAccountsDao extends BaseMapper<AcceptanceFinalAccounts> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    AcceptanceFinalAccounts getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<AcceptanceFinalAccounts> queryAllByPage(IPage<AcceptanceFinalAccounts> convert2IPage, @Param(Constants.WRAPPER) Wrapper<AcceptanceFinalAccounts> convert2Wrapper);

}

